<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('eu', array (
  'validators' => 
  array (
    'This value should be false.' => 'Balio hau faltsua izan beharko litzateke.',
    'This value should be true.' => 'Balio hau egia izan beharko litzateke.',
    'This value should be of type {{ type }}.' => 'Balio hau {{ type }} motakoa izan beharko litzateke.',
    'This value should be blank.' => 'Balio hau hutsik egon beharko litzateke.',
    'The value you selected is not a valid choice.' => 'Hautatu duzun balioa ez da aukera egoki bat.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Gutxienez aukera {{ limit }} hautatu behar duzu.|Gutxienez {{ limit }} aukera hautatu behar dituzu.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Gehienez aukera {{ limit }} hautatu behar duzu.|Gehienez {{ limit }} aukera hautatu behar dituzu.',
    'One or more of the given values is invalid.' => 'Emandako balioetatik gutxienez bat ez da egokia.',
    'This field was not expected.' => 'Eremu hau ez zen espero.',
    'This field is missing.' => 'Eremu hau falta da.',
    'This value is not a valid date.' => 'Balio hau ez da data egoki bat.',
    'This value is not a valid datetime.' => 'Balio hau ez da data-ordu egoki bat.',
    'This value is not a valid email address.' => 'Balio hau ez da posta elektroniko egoki bat.',
    'The file could not be found.' => 'Ezin izan da fitxategia aurkitu.',
    'The file is not readable.' => 'Fitxategia ez da irakurgarria.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Fitxategia handiegia da ({{ size }} {{ suffix }}). Baimendutako tamaina handiena {{ limit }} {{ suffix }} da.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Fitxategiaren mime mota ez da egokia ({{ type }}). Hauek dira baimendutako mime motak: {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Balio hau gehienez {{ limit }} izan beharko litzateke.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Balio hau luzeegia da. Gehienez karaktere {{ limit }} eduki beharko luke.|Balio hau luzeegia da. Gehienez {{ limit }} karaktere eduki beharko lituzke.',
    'This value should be {{ limit }} or more.' => 'Balio hau gutxienez {{ limit }} izan beharko litzateke.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Balio hau motzegia da. Karaktere {{ limit }} gutxienez eduki beharko luke.|Balio hau motzegia da. Gutxienez {{ limit }} karaktere eduki beharko lituzke.',
    'This value should not be blank.' => 'Balio hau ez litzateke hutsik egon behar.',
    'This value should not be null.' => 'Balio hau ez litzateke nulua izan behar.',
    'This value should be null.' => 'Balio hau nulua izan beharko litzateke.',
    'This value is not valid.' => 'Balio hau ez da egokia.',
    'This value is not a valid time.' => 'Balio hau ez da ordu egoki bat.',
    'This value is not a valid URL.' => 'Balio hau ez da baliabideen kokatzaile uniforme (URL) egoki bat.',
    'The two values should be equal.' => 'Bi balioak berdinak izan beharko lirateke.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Fitxategia handiegia da. Baimendutako tamaina handiena {{ limit }} {{ suffix }} da.',
    'The file is too large.' => 'Fitxategia handiegia da.',
    'The file could not be uploaded.' => 'Ezin izan da fitxategia igo.',
    'This value should be a valid number.' => 'Balio hau zenbaki egoki bat izan beharko litzateke.',
    'This file is not a valid image.' => 'Fitxategi hau ez da irudi egoki bat.',
    'This is not a valid IP address.' => 'Balio hau ez da IP helbide baliozko bat.',
    'This value is not a valid language.' => 'Balio hau ez da hizkuntza egoki bat.',
    'This value is not a valid locale.' => 'Balio hau ez da kokapen egoki bat.',
    'This value is not a valid country.' => 'Balio hau ez da herrialde egoki bat.',
    'This value is already used.' => 'Balio hau jadanik erabilia izan da.',
    'The size of the image could not be detected.' => 'Ezin izan da irudiaren tamaina detektatu.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Irudiaren zabalera handiegia da ({{ width }}px). Onartutako gehienezko zabalera {{ max_width }}px dira.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Irudiaren zabalera txikiegia da ({{ width }}px). Onartutako gutxieneko zabalera {{ min_width }}px dira.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Irudiaren altuera handiegia da ({{ height }}px). Onartutako gehienezko altuera {{ max_height }}px dira.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Irudiaren altuera txikiegia da ({{ height }}px). Onartutako gutxieneko altuera {{ min_height }}px dira.',
    'This value should be the user\'s current password.' => 'Balio hau uneko erabiltzailearen pasahitza izan beharko litzateke.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Balio honek zehazki karaktere {{ limit }} izan beharko luke.|Balio honek zehazki {{ limit }} karaktere izan beharko lituzke.',
    'The file was only partially uploaded.' => 'Fitxategiaren zati bat bakarrik igo da.',
    'No file was uploaded.' => 'Ez da fitxategirik igo.',
    'No temporary folder was configured in php.ini.' => 'Ez da aldi baterako karpetarik konfiguratu php.ini-n, edo konfiguratutako karpeta ez da existitzen.',
    'Cannot write temporary file to disk.' => 'Ezin izan da aldi baterako fitxategia diskoan idatzi.',
    'A PHP extension caused the upload to fail.' => 'PHP luzapen batek igoeraren hutsa eragin du.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Bilduma honek gutxienez elementu {{ limit }} eduki beharko luke.|Bilduma honek gutxienez {{ limit }} elementu eduki beharko lituzke.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Bilduma honek gehienez elementu {{ limit }} eduki beharko luke.|Bilduma honek gehienez {{ limit }} elementu eduki beharko lituzke.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Bilduma honek zehazki elementu {{ limit }} eduki beharko luke.|Bilduma honek zehazki {{ limit }} elementu eduki beharko lituzke.',
    'Invalid card number.' => 'Txartel zenbaki baliogabea.',
    'Unsupported card type or invalid card number.' => 'Txartel mota onartezina edo txartel zenbaki baliogabea.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Balio hau ez da Nazioarteko Banku Kontu Zenbaki (IBAN) baliozko bat.',
    'This value is not a valid ISBN-10.' => 'Balio hau ez da onartutako ISBN-10 bat.',
    'This value is not a valid ISBN-13.' => 'Balio hau ez da onartutako ISBN-13 bat.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Balio hau ez da onartutako ISBN-10 edo ISBN-13 bat.',
    'This value is not a valid ISSN.' => 'Balio hau ez da onartutako ISSN bat.',
    'This value is not a valid currency.' => 'Balio hau ez da baliozko moneta bat.',
    'This value should be equal to {{ compared_value }}.' => 'Balio hau {{ compared_value }}-(r)en berbera izan beharko litzateke.',
    'This value should be greater than {{ compared_value }}.' => 'Balio hau {{ compared_value }} baino handiagoa izan beharko litzateke.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Balio hau {{ compared_value }}-(r)en berdina edota handiagoa izan beharko litzateke.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Balio hau {{ compared_value_type }} {{ compared_value }}-(r)en berbera izan beharko litzateke.',
    'This value should be less than {{ compared_value }}.' => 'Balio hau {{ compared_value }} baino txikiagoa izan beharko litzateke.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Balio hau {{ compared_value }}-(r)en berdina edota txikiagoa izan beharko litzateke.',
    'This value should not be equal to {{ compared_value }}.' => 'Balio hau ez litzateke {{ compared_value }}-(r)en berdina izan behar.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Balio hau ez litzateke {{ compared_value_type }} {{ compared_value }}-(r)en berbera izan behar.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Irudiaren proportzioa oso handia da ({{ ratio }}). Onartutako proportzio handienda {{ max_ratio }} da.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Irudiaren proportzioa oso txikia da ({{ ratio }}). Onartutako proportzio txikiena {{ min_ratio }} da.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Irudia karratua da ({{ width }}x{{ height }}px). Karratuak diren irudiak ez dira onartzen.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Irudia horizontalki bideratua dago ({{ width }}x{{ height }}px). Horizontalki bideratutako irudiak ez dira onartzen.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Irudia bertikalki bideratua dago ({{ width }}x{{ height }}px). Bertikalki bideratutako irudiak ez dira onartzen.',
    'An empty file is not allowed.' => 'Hutsik dagoen fitxategia ez da onartzen.',
    'The host could not be resolved.' => 'Host-a ezin da ebatzi.',
    'This value does not match the expected {{ charset }} charset.' => 'Balio honen karaktere kodea ez da esperotakoa {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Balio hau ez da Negozioaren Identifikazio Kode (BIC) baliozko bat.',
    'Error' => 'Errore',
    'This is not a valid UUID.' => 'Balio hau ez da UUID baliozko bat.',
    'This value should be a multiple of {{ compared_value }}.' => 'Balio honek {{ compared_value }}-ren multiploa izan beharko luke.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Banku Identifikazioko Kode hau ez dago lotuta {{ IBAN }} IBAN-rekin.',
    'This value should be valid JSON.' => 'Balio honek baliozko JSON bat izan behar luke.',
    'This collection should contain only unique elements.' => 'Bilduma honek elementu bakarrak soilik izan beharko lituzke.',
    'This value should be positive.' => 'Balio honek positiboa izan beharko luke.',
    'This value should be either positive or zero.' => 'Balio honek positiboa edo zero izan behar luke.',
    'This value should be negative.' => 'Balio honek negatiboa izan behar luke.',
    'This value should be either negative or zero.' => 'Balio honek negatiboa edo zero izan behar luke.',
    'This value is not a valid timezone.' => 'Balio hori ez da baliozko ordu-eremua.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Pasahitz hori ezin da erabili, beste gune eta aplikazio batzuetako segurtasun-akatsei esker lortutako pasahitz publikoen zerrendan sartuta dagoelako. Mesedez, erabili beste pasahitz bat.',
    'This value should be between {{ min }} and {{ max }}.' => 'Balio honek {{ min }} eta {{ max }} artean egon behar luke.',
    'This value is not a valid hostname.' => 'Balio hori ez da ostalari-izen onargarria.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Bilduma honetako elementu-kopuruak {{ compared_value }}-ren multiploa izan behar luke.',
    'This value should satisfy at least one of the following constraints:' => 'Balio honek, gutxienez, murrizketa hauetako bat bete behar du:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Bilduma honetako elementu bakoitzak bere murriztapen-multzoa bete behar du.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Balio hori ez da baliozko baloreen nazioarteko identifikazio-zenbaki bat (ISIN).',
    'This value should be a valid expression.' => 'Balio hori baliozko adierazpena izan beharko litzateke.',
    'This value is not a valid CSS color.' => 'Balio hori ez da baliozko CSS kolorea.',
    'This value is not a valid CIDR notation.' => 'Balio hori ez da baliozko CIDR notazioa.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'Maskararen balioa {{ min }} eta {{ max }} artekoa izan beharko litzateke.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'Fitxategiaren izena luzeegia da. Karaktere {{ filename_max_length }} edo gutxiago izan beharko lituzke.|Fitxategiaren izena luzeegia da. {{ filename_max_length }} karaktere edo gutxiago izan beharko lituzke.',
    'The password strength is too low. Please use a stronger password.' => 'Pasahitzaren sendotasuna baxuegia da. Mesedez, erabili pasahitz seguruagoa.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'Egungo murrizte-mailak ez du balio honek dituen karaktereak onartzen.',
    'Using invisible characters is not allowed.' => 'Ez da onartzen karaktere ikusezinak erabiltzea.',
    'Mixing numbers from different scripts is not allowed.' => 'Ez da onartzen script ezberdinetako zenbakiak nahastea',
    'Using hidden overlay characters is not allowed.' => 'Ez da onartzen karaktere gainjarri ezkutuen erabilera.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'Fitxategiaren luzapena ez da zuzena ({{ extension }}). Baimendutako luzapenak hauek dira: {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'Detektatutako karaktere-kodetzea ez da zuzena ({{ detected }}). Baimendutako kodetzeak hauek dira: {{ encodings }}.',
    'This value is not a valid MAC address.' => 'Balio hau ez da MAC helbide baliozko bat.',
    'This URL is missing a top-level domain.' => 'URL honek ez du goi-mailako domeinurik.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'Balio hau oso laburra da. Gutxienez hitz bat izan behar du.|Balio hau oso laburra da. Gutxienez {{ min }} hitz izan behar ditu.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'Balio hau oso luzea da. Hitz bat bakarrik izan behar du.|Balio hau oso luzea da. {{ max }} hitz edo gutxiago izan behar ditu.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'Balio honek ez du ISO 8601 formatuan aste baliozko bat adierazten.',
    'This value is not a valid week.' => 'Balio hau ez da aste balioduna.',
    'This value should not be before week "{{ min }}".' => 'Balio hau ez luke aste "{{ min }}" baino lehenagokoa izan behar.',
    'This value should not be after week "{{ max }}".' => 'Balio hau ez luke astearen "{{ max }}" ondoren egon behar.',
    'This value is not a valid Twig template.' => 'Balio hau ez da Twig txantiloi baliozko bat.',
    'This file is not a valid video.' => 'Fitxategi hau ez da baliozko bideo bat.',
    'The size of the video could not be detected.' => 'Ezin izan da bideoaren tamaina detektatu.',
    'The video width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Bideoaren zabalera handiegia da ({{ width }}px). Baimendutako gehieneko zabalera {{ max_width }}px da.',
    'The video width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Bideoaren zabalera txikiegia da ({{ width }}px). Gutxieneko espero den zabalera {{ min_width }}px da.',
    'The video height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Bideoaren altuera handiegia da ({{ height }}px). Onartutako gehienezko altuera {{ max_height }}px da.',
    'The video height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Bideoaren altuera txikiegia da ({{ height }}px). Espero den gutxieneko altuera {{ min_height }}px da.',
    'The video has too few pixels ({{ pixels }} pixels). Minimum amount expected is {{ min_pixels }} pixels.' => 'Bideoak pixel gutiegi ditu ({{ pixels }}). Gutxieneko espero den kopurua {{ min_pixels }} da.',
    'The video has too many pixels ({{ pixels }} pixels). Maximum amount expected is {{ max_pixels }} pixels.' => 'Bideoak pixel gehiegi ditu ({{ pixels }}). Espero den gehieneko kopurua {{ max_pixels }} da.',
    'The video ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Bideoaren erlazioa handiegia da ({{ ratio }}). Onartutako gehieneko erlazioa {{ max_ratio }} da.',
    'The video ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Bideoaren erlazioa txikiegia da ({{ ratio }}). Espero den gutxieneko erlazioa {{ min_ratio }} da.',
    'The video is square ({{ width }}x{{ height }}px). Square videos are not allowed.' => 'Bideoa karratua da ({{ width }}x{{ height }}px). Bideo karratuak ez dira onartzen.',
    'The video is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented videos are not allowed.' => 'Bideoa paisaia orientazioan dago ({{ width }}x{{ height }} px). Paisaia-orientazioko bideoak ez daude baimenduta.',
    'The video is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented videos are not allowed.' => 'Bideoa bertikal orientatuta dago ({{ width }}x{{ height }} px). Orientazio bertikaleko bideoak ez dira onartzen.',
    'The video file is corrupted.' => 'Bideo fitxategia hondatuta dago.',
    'The video contains multiple streams. Only one stream is allowed.' => 'Bideoak korronte anitz ditu. Korronte bakarra onartzen da.',
    'Unsupported video codec "{{ codec }}".' => 'Bideo kodek onartugabea "{{ codec }}".',
    'Unsupported video container "{{ container }}".' => 'Onartzen ez den bideo edukiontzia "{{ container }}".',
    'The image file is corrupted.' => 'Irudi fitxategia hondatuta dago.',
    'The image has too few pixels ({{ pixels }} pixels). Minimum amount expected is {{ min_pixels }} pixels.' => 'Irudiak pixelen kopuru gutiegi du ({{ pixels }}). Espero den gutxienekoa {{ min_pixels }} da.',
    'The image has too many pixels ({{ pixels }} pixels). Maximum amount expected is {{ max_pixels }} pixels.' => 'Irudiak pixel gehiegi ditu ({{ pixels }}). Espero den gehienezko kopurua {{ max_pixels }} da.',
    'This filename does not match the expected charset.' => 'Fitxategi-izen honek ez du espero zen karaktere multzoarekin bat egiten.',
    'This form should not contain extra fields.' => 'Formulario honek ez luke aparteko eremurik eduki behar.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Igotako fitxategia handiegia da. Mesedez saiatu fitxategi txikiago bat igotzen.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRF tokena baliogabea da. Mesedez, saiatu berriro formularioa bidaltzen.',
    'This value is not a valid HTML5 color.' => 'Balio hori ez da HTML5 kolore onargarria.',
    'Please enter a valid birthdate.' => 'Mesedez, sartu baliozko urtebetetze-eguna.',
    'The selected choice is invalid.' => 'Hautatutako aukera ez da egokia.',
    'The collection is invalid.' => 'Bilduma ez da baliozkoa.',
    'Please select a valid color.' => 'Mesedez, hautatu baliozko kolore bat.',
    'Please select a valid country.' => 'Mesedez, hautatu baliozko herrialde bat.',
    'Please select a valid currency.' => 'Mesedez, hautatu baliozko moneta bat.',
    'Please choose a valid date interval.' => 'Mesedez, hautatu baliozko data-tarte bat.',
    'Please enter a valid date and time.' => 'Mesedez, sartu baliozko data eta ordua.',
    'Please enter a valid date.' => 'Mesedez, sartu baliozko data bat.',
    'Please select a valid file.' => 'Mesedez, hautatu baliozko fitxategi bat.',
    'The hidden field is invalid.' => 'Eremu ezkutua ez da baliozkoa.',
    'Please enter an integer.' => 'Mesedez, sartu zenbaki oso bat.',
    'Please select a valid language.' => 'Mesedez, hautatu baliozko hizkuntza bat.',
    'Please select a valid locale.' => 'Mesedez, hautatu baliozko eskualde-konfigurazio bat.',
    'Please enter a valid money amount.' => 'Mesedez, sartu baliozko diru-kopuru bat.',
    'Please enter a number.' => 'Mesedez, sartu zenbaki bat.',
    'The password is invalid.' => 'Pasahitza ez da zuzena.',
    'Please enter a percentage value.' => 'Mesedez, sartu portzentajezko balio bat.',
    'The values do not match.' => 'Balioak ez datoz bat.',
    'Please enter a valid time.' => 'Mesedez, sartu baliozko ordu bat.',
    'Please select a valid timezone.' => 'Mesedez, hautatu baliozko ordu-eremua.',
    'Please enter a valid URL.' => 'Mesedez, sartu baliozko URL bat.',
    'Please enter a valid search term.' => 'Mesedez, sartu bilaketa-termino onargarri bat.',
    'Please provide a valid phone number.' => 'Mesedez, eman baliozko telefono-zenbaki bat.',
    'The checkbox has an invalid value.' => 'Egiaztatze-laukiak balio baliogabea du.',
    'Please enter a valid email address.' => 'Mesedez, sartu baliozko helbide elektroniko bat.',
    'Please select a valid option.' => 'Mesedez, hautatu baliozko aukera bat.',
    'Please select a valid range.' => 'Mesedez, hautatu baliozko tarte bat.',
    'Please enter a valid week.' => 'Mesedez, sartu baliozko aste bat.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Autentifikazio-errorea gertatu da.',
    'Authentication credentials could not be found.' => 'Ez dira aurkitu autentifikazio-kredentzialak.',
    'Authentication request could not be processed due to a system problem.' => 'Ezin izan da autentifikazio-eskaera prozesatu, sistema-arazo bat gertatu da eta.',
    'Invalid credentials.' => 'Kredentzialak okerrak dira.',
    'Cookie has already been used by someone else.' => 'Dagoeneko beste pertsona batek erabili du cookiea.',
    'Not privileged to request the resource.' => 'Ez duzu baliabidea eskatzeko aukerarik.',
    'Invalid CSRF token.' => 'CSRF tokena okerra da.',
    'No authentication provider found to support the authentication token.' => 'Ez da aurkitu autentifikazio-tokena eutsi dezakeen autentifikazio-hornitzailerik.',
    'No session available, it either timed out or cookies are not enabled.' => 'Ez dago saiorik erabilgarri, iraungi egin da edo cookieak ez daude gaituta.',
    'No token could be found.' => 'Ez da tokenik aurkitu.',
    'Username could not be found.' => 'Ez da erabiltzaile-izena aurkitu.',
    'Account has expired.' => 'Kontua iraungi da.',
    'Credentials have expired.' => 'Kredentzialak iraungi dira.',
    'Account is disabled.' => 'Kontua desgaituta dago.',
    'Account is locked.' => 'Kontua blokeatuta dago.',
    'Too many failed login attempts, please try again later.' => 'Saioa hasteko saio huts gehiegi, saiatu berriro geroago.',
    'Invalid or expired login link.' => 'Sartzeko esteka baliogabea edo iraungia.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Saioa hasteko huts gehiegi egin dira, saiatu berriro minutu %minutes% geroago.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Saioa hasteko saiakera huts gehiegi, saiatu berriro %minutes% minututan.',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This value is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This value is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This value is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This value is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.',
    'The password strength is too low. Please use a stronger password.' => 'The password strength is too low. Please use a stronger password.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'This value contains characters that are not allowed by the current restriction-level.',
    'Using invisible characters is not allowed.' => 'Using invisible characters is not allowed.',
    'Mixing numbers from different scripts is not allowed.' => 'Mixing numbers from different scripts is not allowed.',
    'Using hidden overlay characters is not allowed.' => 'Using hidden overlay characters is not allowed.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.',
    'This value is not a valid MAC address.' => 'This value is not a valid MAC address.',
    'This URL is missing a top-level domain.' => 'This URL is missing a top-level domain.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'This value does not represent a valid week in the ISO 8601 format.',
    'This value is not a valid week.' => 'This value is not a valid week.',
    'This value should not be before week "{{ min }}".' => 'This value should not be before week "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'This value should not be after week "{{ max }}".',
    'This value is not a valid Twig template.' => 'This value is not a valid Twig template.',
    'This file is not a valid video.' => 'This file is not a valid video.',
    'The size of the video could not be detected.' => 'The size of the video could not be detected.',
    'The video width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The video width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The video width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The video width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The video height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The video height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The video height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The video height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'The video has too few pixels ({{ pixels }} pixels). Minimum amount expected is {{ min_pixels }} pixels.' => 'The video has too few pixels ({{ pixels }} pixels). Minimum amount expected is {{ min_pixels }} pixels.',
    'The video has too many pixels ({{ pixels }} pixels). Maximum amount expected is {{ max_pixels }} pixels.' => 'The video has too many pixels ({{ pixels }} pixels). Maximum amount expected is {{ max_pixels }} pixels.',
    'The video ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The video ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The video ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The video ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The video is square ({{ width }}x{{ height }}px). Square videos are not allowed.' => 'The video is square ({{ width }}x{{ height }}px). Square videos are not allowed.',
    'The video is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented videos are not allowed.' => 'The video is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented videos are not allowed.',
    'The video is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented videos are not allowed.' => 'The video is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented videos are not allowed.',
    'The video file is corrupted.' => 'The video file is corrupted.',
    'The video contains multiple streams. Only one stream is allowed.' => 'The video contains multiple streams. Only one stream is allowed.',
    'Unsupported video codec "{{ codec }}".' => 'Unsupported video codec "{{ codec }}".',
    'Unsupported video container "{{ container }}".' => 'Unsupported video container "{{ container }}".',
    'The image file is corrupted.' => 'The image file is corrupted.',
    'The image has too few pixels ({{ pixels }} pixels). Minimum amount expected is {{ min_pixels }} pixels.' => 'The image has too few pixels ({{ pixels }} pixels). Minimum amount expected is {{ min_pixels }} pixels.',
    'The image has too many pixels ({{ pixels }} pixels). Maximum amount expected is {{ max_pixels }} pixels.' => 'The image has too many pixels ({{ pixels }} pixels). Maximum amount expected is {{ max_pixels }} pixels.',
    'This filename does not match the expected charset.' => 'This filename does not match the expected charset.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
