<?php

namespace ContainerItFQyas;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class App_KernelProdContainer extends Container
{
    private const DEPRECATED_PARAMETERS = [
        'security.authentication.hide_user_not_found' => ['symfony/security-bundle', '7.4', 'The parameter "%s" is deprecated.', 'security.authentication.hide_user_not_found'],
    ];

    private const NONEMPTY_PARAMETERS = [
        'kernel.secret' => 'A non-empty value for the parameter "kernel.secret" is required. Did you forget to configure the "APP_SECRET" env var?',
    ];

    protected $targetDir;
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct(private array $buildParameters = [], protected string $containerDir = __DIR__)
    {
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            'api_platform.cache.metadata.property' => 'getApiPlatform_Cache_Metadata_PropertyService',
            'api_platform.cache.metadata.resource' => 'getApiPlatform_Cache_Metadata_ResourceService',
            'api_platform.cache.metadata.resource_collection' => 'getApiPlatform_Cache_Metadata_ResourceCollectionService',
            'cache.security_is_csrf_token_valid_attribute_expression_language' => 'getCache_SecurityIsCsrfTokenValidAttributeExpressionLanguageService',
            'cache.security_is_granted_attribute_expression_language' => 'getCache_SecurityIsGrantedAttributeExpressionLanguageService',
            'doctrine' => 'getDoctrineService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'event_dispatcher' => 'getEventDispatcherService',
            'http_kernel' => 'getHttpKernelService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'translator' => 'getTranslatorService',
        ];
        $this->fileMap = [
            'App\\Controller\\ExamSubjectsController' => 'getExamSubjectsControllerService',
            'App\\Controller\\ForgotPasswordController' => 'getForgotPasswordControllerService',
            'App\\Controller\\ResendVerificationController' => 'getResendVerificationControllerService',
            'App\\Controller\\ResetPasswordController' => 'getResetPasswordControllerService',
            'App\\Controller\\SubscriptionController' => 'getSubscriptionControllerService',
            'App\\Controller\\UserFinanceController' => 'getUserFinanceControllerService',
            'App\\Controller\\VerifyEmailController' => 'getVerifyEmailControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'api_platform.action.documentation' => 'getApiPlatform_Action_DocumentationService',
            'api_platform.action.entrypoint' => 'getApiPlatform_Action_EntrypointService',
            'api_platform.action.not_exposed' => 'getApiPlatform_Action_NotExposedService',
            'api_platform.action.not_found' => 'getApiPlatform_Action_NotFoundService',
            'api_platform.cache.openapi' => 'getApiPlatform_Cache_OpenapiService',
            'api_platform.cache.route_name_resolver' => 'getApiPlatform_Cache_RouteNameResolverService',
            'api_platform.jsonld.action.context' => 'getApiPlatform_Jsonld_Action_ContextService',
            'api_platform.state_provider.parameter_validator' => 'getApiPlatform_StateProvider_ParameterValidatorService',
            'api_platform.symfony.main_controller' => 'getApiPlatform_Symfony_MainControllerService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.http_client.pool' => 'getCache_HttpClient_PoolService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'container.get_routing_condition_service' => 'getContainer_GetRoutingConditionServiceService',
            'debug.error_handler_configurator' => 'getDebug_ErrorHandlerConfiguratorService',
            'error_controller' => 'getErrorControllerService',
            'lexik_jwt_authentication.encoder' => 'getLexikJwtAuthentication_EncoderService',
            'lexik_jwt_authentication.generate_token_command' => 'getLexikJwtAuthentication_GenerateTokenCommandService',
            'lexik_jwt_authentication.jwt_manager' => 'getLexikJwtAuthentication_JwtManagerService',
            'lexik_jwt_authentication.key_loader' => 'getLexikJwtAuthentication_KeyLoaderService',
            'messenger.default_bus' => 'getMessenger_DefaultBusService',
            'monolog.logger.deprecation' => 'getMonolog_Logger_DeprecationService',
            'routing.loader' => 'getRouting_LoaderService',
            'services_resetter' => 'getServicesResetterService',
        ];
        $this->aliases = [
            'ApiPlatform\\Symfony\\Action\\NotExposedAction' => 'api_platform.action.not_exposed',
            'ApiPlatform\\Symfony\\Action\\NotFoundAction' => 'api_platform.action.not_found',
            'App\\Kernel' => 'kernel',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
        ];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true): mixed
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /*
     * Gets the public 'api_platform.cache.metadata.property' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_PropertyService($container)
    {
        return $container->services['api_platform.cache.metadata.property'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('-q2bzHHI17', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'api_platform.cache.metadata.resource' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_ResourceService($container)
    {
        return $container->services['api_platform.cache.metadata.resource'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('MWj48o2Vn8', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'api_platform.cache.metadata.resource_collection' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getApiPlatform_Cache_Metadata_ResourceCollectionService($container)
    {
        return $container->services['api_platform.cache.metadata.resource_collection'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('cNcK5aXJN9', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'cache.security_is_csrf_token_valid_attribute_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityIsCsrfTokenValidAttributeExpressionLanguageService($container)
    {
        return $container->services['cache.security_is_csrf_token_valid_attribute_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('BAoGs0kJvK', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'cache.security_is_granted_attribute_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityIsGrantedAttributeExpressionLanguageService($container)
    {
        return $container->services['cache.security_is_granted_attribute_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('aGAyRP+kmi', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'doctrine' shared service.
     *
     * @return \Doctrine\Bundle\DoctrineBundle\Registry
     */
    protected static function getDoctrineService($container)
    {
        return $container->services['doctrine'] = new \Doctrine\Bundle\DoctrineBundle\Registry($container, $container->parameters['doctrine.connections'], $container->parameters['doctrine.entity_managers'], 'default', 'default');
    }

    /*
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected static function getDoctrine_Dbal_DefaultConnectionService($container)
    {
        $a = new \Doctrine\DBAL\Configuration();

        $b = new \Doctrine\Bundle\DoctrineBundle\Middleware\IdleConnectionMiddleware(($container->privates['doctrine.dbal.connection_expiries'] ??= new \ArrayObject()), ['default' => 600]);
        $b->setConnectionName('default');

        $a->setSchemaManagerFactory(new \Doctrine\DBAL\Schema\DefaultSchemaManagerFactory());
        $a->setSchemaAssetsFilter(new \Doctrine\Bundle\DoctrineBundle\Dbal\SchemaAssetsFilterManager([($container->privates['doctrine_migrations.schema_filter_listener'] ??= new \Doctrine\Bundle\MigrationsBundle\EventListener\SchemaFilterListener('doctrine_migration_versions'))]));
        $a->setMiddlewares([$b]);

        return $container->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory($container->parameters['doctrine.dbal.connection_factory.types'], new \Doctrine\DBAL\Tools\DsnParser(['db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite'])))->createConnection(['url' => $container->getEnv('resolve:DATABASE_URL'), 'use_savepoints' => true, 'driver' => 'pdo_mysql', 'idle_connection_ttl' => 600, 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [], 'defaultTableOptions' => []], $a, NULL, []);
    }

    /*
     * Gets the public 'doctrine.orm.default_entity_manager' shared service.
     *
     * @return \Doctrine\ORM\EntityManager
     */
    protected static function getDoctrine_Orm_DefaultEntityManagerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['doctrine.orm.default_entity_manager'] = $container->createProxy('EntityManagerGhostC135a4f', static fn () => \EntityManagerGhostC135a4f::createLazyGhost(static fn ($proxy) => self::getDoctrine_Orm_DefaultEntityManagerService($container, $proxy)));
        }

        $instance = ($lazyLoad->__construct(($container->services['doctrine.dbal.default_connection'] ?? self::getDoctrine_Dbal_DefaultConnectionService($container)), ($container->privates['doctrine.orm.default_configuration'] ?? self::getDoctrine_Orm_DefaultConfigurationService($container)), ($container->privates['doctrine.dbal.default_connection.event_manager'] ?? self::getDoctrine_Dbal_DefaultConnection_EventManagerService($container))) && false ?: $lazyLoad);

        ($container->privates['doctrine.orm.default_manager_configurator'] ??= new \Doctrine\Bundle\DoctrineBundle\ManagerConfigurator([], []))->configure($instance);

        return $instance;
    }

    /*
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        $container->services['event_dispatcher'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('lexik_jwt_authentication.on_authentication_success', [#[\Closure(name: 'App\\EventListener\\EmailVerificationListener')] fn () => ($container->privates['App\\EventListener\\EmailVerificationListener'] ??= new \App\EventListener\EmailVerificationListener()), 'onAuthenticationSuccess'], 0);
        $instance->addListener('lexik_jwt_authentication.on_jwt_created', [#[\Closure(name: 'App\\EventListener\\JWTCreatedListener')] fn () => ($container->privates['App\\EventListener\\JWTCreatedListener'] ??= new \App\EventListener\JWTCreatedListener()), 'onJWTCreated'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.csrf.same_origin_token_manager', class: 'Symfony\\Component\\Security\\Csrf\\SameOriginCsrfTokenManager')] fn () => ($container->privates['security.csrf.same_origin_token_manager'] ?? self::getSecurity_Csrf_SameOriginTokenManagerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('console.command', [#[\Closure(name: 'doctrine_migrations.schema_filter_listener', class: 'Doctrine\\Bundle\\MigrationsBundle\\EventListener\\SchemaFilterListener')] fn () => ($container->privates['doctrine_migrations.schema_filter_listener'] ??= new \Doctrine\Bundle\MigrationsBundle\EventListener\SchemaFilterListener('doctrine_migration_versions')), 'onConsoleCommand'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'turbo.kernel.request_listener', class: 'Symfony\\UX\\Turbo\\Request\\RequestListener')] fn () => ($container->privates['turbo.kernel.request_listener'] ??= new \Symfony\UX\Turbo\Request\RequestListener()), '__invoke'], 256);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('kernel.response', [#[\Closure(name: 'security.context_listener.0', class: 'Symfony\\Component\\Security\\Http\\Firewall\\ContextListener')] fn () => ($container->privates['security.context_listener.0'] ?? self::getSecurity_ContextListener_0Service($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'nelmio_cors.cors_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CorsListener')] fn () => ($container->privates['nelmio_cors.cors_listener'] ?? self::getNelmioCors_CorsListenerService($container)), 'onKernelRequest'], 250);
        $instance->addListener('kernel.response', [#[\Closure(name: 'nelmio_cors.cors_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CorsListener')] fn () => ($container->privates['nelmio_cors.cors_listener'] ?? self::getNelmioCors_CorsListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'nelmio_cors.cacheable_response_vary_listener', class: 'Nelmio\\CorsBundle\\EventListener\\CacheableResponseVaryListener')] fn () => ($container->privates['nelmio_cors.cacheable_response_vary_listener'] ??= new \Nelmio\CorsBundle\EventListener\CacheableResponseVaryListener()), 'onResponse'], -10);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'api_platform.listener.exception', class: 'ApiPlatform\\Symfony\\EventListener\\ExceptionListener')] fn () => ($container->privates['api_platform.listener.exception'] ?? $container->load('getApiPlatform_Listener_ExceptionService')), 'onKernelException'], -96);
        $instance->addListener('kernel.view', [#[\Closure(name: 'App\\EventSubscriber\\PracticeTestSubscriber')] fn () => ($container->privates['App\\EventSubscriber\\PracticeTestSubscriber'] ?? $container->load('getPracticeTestSubscriberService')), 'populateQuestions'], 33);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'argument_resolver.request_payload', class: 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver')] fn () => ($container->privates['argument_resolver.request_payload'] ?? self::getArgumentResolver_RequestPayloadService($container)), 'onKernelControllerArguments'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'response_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ResponseListener')] fn () => ($container->privates['response_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleListener')] fn () => ($container->privates['locale_listener'] ?? self::getLocaleListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'validate_request_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ValidateRequestListener')] fn () => ($container->privates['validate_request_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()), 'onKernelRequest'], 256);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'onKernelException'], -128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'exception_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\ErrorListener')] fn () => ($container->privates['exception_listener'] ?? self::getExceptionListenerService($container)), 'removeCspHeader'], -128);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelControllerArguments'], 10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'controller.cache_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\CacheAttributeListener')] fn () => ($container->privates['controller.cache_attribute_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\CacheAttributeListener()), 'onKernelResponse'], -10);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.is_signature_valid_attribute_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\IsSignatureValidAttributeListener')] fn () => ($container->privates['controller.is_signature_valid_attribute_listener'] ?? self::getController_IsSignatureValidAttributeListenerService($container)), 'onKernelControllerArguments'], 30);
        $instance->addListener('kernel.request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'locale_aware_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\LocaleAwareListener')] fn () => ($container->privates['locale_aware_listener'] ?? self::getLocaleAwareListenerService($container)), 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [#[\Closure(name: 'console.error_listener', class: 'Symfony\\Component\\Console\\EventListener\\ErrorListener')] fn () => ($container->privates['console.error_listener'] ?? $container->load('getConsole_ErrorListenerService')), 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [#[\Closure(name: 'console.suggest_missing_package_subscriber', class: 'Symfony\\Bundle\\FrameworkBundle\\EventListener\\SuggestMissingPackageSubscriber')] fn () => ($container->privates['console.suggest_missing_package_subscriber'] ??= new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()), 'onConsoleError'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.envelope_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\EnvelopeListener')] fn () => ($container->privates['mailer.envelope_listener'] ??= new \Symfony\Component\Mailer\EventListener\EnvelopeListener(NULL, NULL, [])), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.message_logger_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageLoggerListener')] fn () => ($container->privates['mailer.message_logger_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()), 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'mailer.messenger_transport_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessengerTransportListener')] fn () => ($container->privates['mailer.messenger_transport_listener'] ??= new \Symfony\Component\Mailer\EventListener\MessengerTransportListener()), 'onMessage'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('console.command', [#[\Closure(name: 'debug.debug_handlers_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\DebugHandlersListener')] fn () => ($container->privates['debug.debug_handlers_listener'] ??= new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'))), 'configure'], 2048);
        $instance->addListener('kernel.request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'router_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\RouterListener')] fn () => ($container->privates['router_listener'] ?? self::getRouterListenerService($container)), 'onKernelException'], -64);
        $instance->addListener('kernel.response', [#[\Closure(name: 'web_link.add_link_header_listener', class: 'Symfony\\Component\\WebLink\\EventListener\\AddLinkHeaderListener')] fn () => ($container->privates['web_link.add_link_header_listener'] ?? self::getWebLink_AddLinkHeaderListenerService($container)), 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [#[\Closure(name: 'session_listener', class: 'Symfony\\Component\\HttpKernel\\EventListener\\SessionListener')] fn () => ($container->privates['session_listener'] ?? self::getSessionListenerService($container)), 'onKernelResponse'], -1000);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.retry.send_failed_message_for_retry_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\SendFailedMessageForRetryListener')] fn () => ($container->privates['messenger.retry.send_failed_message_for_retry_listener'] ?? $container->load('getMessenger_Retry_SendFailedMessageForRetryListenerService')), 'onMessageFailed'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.failure.add_error_details_stamp_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\AddErrorDetailsStampListener')] fn () => ($container->privates['messenger.failure.add_error_details_stamp_listener'] ??= new \Symfony\Component\Messenger\EventListener\AddErrorDetailsStampListener()), 'onMessageFailed'], 200);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.failure.send_failed_message_to_failure_transport_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\SendFailedMessageToFailureTransportListener')] fn () => ($container->privates['messenger.failure.send_failed_message_to_failure_transport_listener'] ?? $container->load('getMessenger_Failure_SendFailedMessageToFailureTransportListenerService')), 'onMessageFailed'], -100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageSkipEvent', [#[\Closure(name: 'messenger.failure.send_failed_message_to_failure_transport_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\SendFailedMessageToFailureTransportListener')] fn () => ($container->privates['messenger.failure.send_failed_message_to_failure_transport_listener'] ?? $container->load('getMessenger_Failure_SendFailedMessageToFailureTransportListenerService')), 'onMessageSkip'], -100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.dispatch_pcntl_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\DispatchPcntlSignalListener')] fn () => ($container->privates['messenger.listener.dispatch_pcntl_signal_listener'] ??= new \Symfony\Component\Messenger\EventListener\DispatchPcntlSignalListener()), 'onWorkerRunning'], 100);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerStartedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_restart_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnRestartSignalListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $container->load('getMessenger_Listener_StopWorkerOnRestartSignalListenerService')), 'onWorkerStarted'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_restart_signal_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnRestartSignalListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $container->load('getMessenger_Listener_StopWorkerOnRestartSignalListenerService')), 'onWorkerRunning'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_stop_exception_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnCustomStopExceptionListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_stop_exception_listener'] ??= new \Symfony\Component\Messenger\EventListener\StopWorkerOnCustomStopExceptionListener()), 'onMessageFailed'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.stop_worker_on_stop_exception_listener', class: 'Symfony\\Component\\Messenger\\EventListener\\StopWorkerOnCustomStopExceptionListener')] fn () => ($container->privates['messenger.listener.stop_worker_on_stop_exception_listener'] ??= new \Symfony\Component\Messenger\EventListener\StopWorkerOnCustomStopExceptionListener()), 'onWorkerRunning'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageReceivedEvent', [#[\Closure(name: 'messenger.listener.reset_memory_usage', class: 'Symfony\\Component\\Messenger\\EventListener\\ResetMemoryUsageListener')] fn () => ($container->privates['messenger.listener.reset_memory_usage'] ??= new \Symfony\Component\Messenger\EventListener\ResetMemoryUsageListener()), 'resetBefore'], -1024);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerRunningEvent', [#[\Closure(name: 'messenger.listener.reset_memory_usage', class: 'Symfony\\Component\\Messenger\\EventListener\\ResetMemoryUsageListener')] fn () => ($container->privates['messenger.listener.reset_memory_usage'] ??= new \Symfony\Component\Messenger\EventListener\ResetMemoryUsageListener()), 'collectAfter'], -1024);
        $instance->addListener('Symfony\\Component\\Notifier\\Event\\MessageEvent', [#[\Closure(name: 'notifier.notification_logger_listener', class: 'Symfony\\Component\\Notifier\\EventListener\\NotificationLoggerListener')] fn () => ($container->privates['notifier.notification_logger_listener'] ??= new \Symfony\Component\Notifier\EventListener\NotificationLoggerListener()), 'onNotification'], -255);
        $instance->addListener('kernel.request', [#[\Closure(name: 'doctrine.dbal.idle_connection_listener', class: 'Symfony\\Bridge\\Doctrine\\Middleware\\IdleConnection\\Listener')] fn () => ($container->privates['doctrine.dbal.idle_connection_listener'] ?? self::getDoctrine_Dbal_IdleConnectionListenerService($container)), 'onKernelRequest'], 192);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageHandledEvent', [#[\Closure(name: 'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager', class: 'Symfony\\Bridge\\Doctrine\\Messenger\\DoctrineClearEntityManagerWorkerSubscriber')] fn () => ($container->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $container->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService')), 'onWorkerMessageHandled'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\WorkerMessageFailedEvent', [#[\Closure(name: 'doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager', class: 'Symfony\\Bridge\\Doctrine\\Messenger\\DoctrineClearEntityManagerWorkerSubscriber')] fn () => ($container->privates['doctrine.orm.messenger.event_subscriber.doctrine_clear_entity_manager'] ?? $container->load('getDoctrine_Orm_Messenger_EventSubscriber_DoctrineClearEntityManagerService')), 'onWorkerMessageFailed'], 0);
        $instance->addListener('kernel.view', [#[\Closure(name: 'controller.template_attribute_listener', class: 'Symfony\\Bridge\\Twig\\EventListener\\TemplateAttributeListener')] fn () => ($container->privates['controller.template_attribute_listener'] ?? $container->load('getController_TemplateAttributeListenerService')), 'onKernelView'], -128);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [#[\Closure(name: 'twig.mailer.message_listener', class: 'Symfony\\Component\\Mailer\\EventListener\\MessageListener')] fn () => ($container->privates['twig.mailer.message_listener'] ?? $container->load('getTwig_Mailer_MessageListenerService')), 'onMessage'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\FirewallListener')] fn () => ($container->privates['security.firewall'] ?? self::getSecurity_FirewallService($container)), 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [#[\Closure(name: 'security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\FirewallListener')] fn () => ($container->privates['security.firewall'] ?? self::getSecurity_FirewallService($container)), 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [#[\Closure(name: 'security.firewall', class: 'Symfony\\Bundle\\SecurityBundle\\EventListener\\FirewallListener')] fn () => ($container->privates['security.firewall'] ?? self::getSecurity_FirewallService($container)), 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.is_granted_attribute_listener', class: 'Symfony\\Component\\Security\\Http\\EventListener\\IsGrantedAttributeListener')] fn () => ($container->privates['controller.is_granted_attribute_listener'] ?? self::getController_IsGrantedAttributeListenerService($container)), 'onKernelControllerArguments'], 20);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('console.command', [#[\Closure(name: 'monolog.handler.console', class: 'Symfony\\Bridge\\Monolog\\Handler\\ConsoleHandler')] fn () => ($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)), 'onCommand'], 255);
        $instance->addListener('console.terminate', [#[\Closure(name: 'monolog.handler.console', class: 'Symfony\\Bridge\\Monolog\\Handler\\ConsoleHandler')] fn () => ($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)), 'onTerminate'], -255);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('kernel.controller_arguments', [#[\Closure(name: 'controller.is_csrf_token_valid_attribute_listener', class: 'Symfony\\Component\\Security\\Http\\EventListener\\IsCsrfTokenValidAttributeListener')] fn () => ($container->privates['controller.is_csrf_token_valid_attribute_listener'] ?? self::getController_IsCsrfTokenValidAttributeListenerService($container)), 'onKernelControllerArguments'], 25);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /*
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected static function getHttpKernelService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['http_kernel'])) {
            return $container->services['http_kernel'];
        }
        $b = new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($container, ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)));
        $b->allowControllers(['Symfony\\Bundle\\FrameworkBundle\\Controller\\AbstractController', 'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController']);
        $b->allowControllers(['App\\Kernel', 'App\\Controller\\ExamSubjectsController', 'App\\Controller\\ForgotPasswordController', 'App\\Controller\\ResendVerificationController', 'App\\Controller\\ResetPasswordController', 'App\\Controller\\SubscriptionController', 'App\\Controller\\UserFinanceController', 'App\\Controller\\VerifyEmailController', 'Doctrine\\Bundle\\DoctrineBundle\\Controller\\ProfilerController']);

        return $container->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel($a, $b, ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.user_value_resolver'] ?? $container->load('getSecurity_UserValueResolverService'));
            yield 1 => ($container->privates['security.security_token_value_resolver'] ?? $container->load('getSecurity_SecurityTokenValueResolverService'));
            yield 2 => ($container->privates['doctrine.orm.entity_value_resolver'] ?? $container->load('getDoctrine_Orm_EntityValueResolverService'));
            yield 3 => ($container->privates['argument_resolver.backed_enum_resolver'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\BackedEnumValueResolver());
            yield 4 => ($container->privates['argument_resolver.uid'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\UidValueResolver());
            yield 5 => ($container->privates['argument_resolver.datetime'] ?? $container->load('getArgumentResolver_DatetimeService'));
            yield 6 => ($container->privates['argument_resolver.request_attribute'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestAttributeValueResolver());
            yield 7 => ($container->privates['argument_resolver.request'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver());
            yield 8 => ($container->privates['argument_resolver.session'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\SessionValueResolver());
            yield 9 => ($container->privates['api_platform.argument_resolver.payload'] ?? $container->load('getApiPlatform_ArgumentResolver_PayloadService'));
            yield 10 => ($container->privates['argument_resolver.service'] ?? $container->load('getArgumentResolver_ServiceService'));
            yield 11 => ($container->privates['argument_resolver.default'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DefaultValueResolver());
            yield 12 => ($container->privates['argument_resolver.variadic'] ??= new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\VariadicValueResolver());
        }, 13), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => ['privates', 'argument_resolver.request_payload', 'getArgumentResolver_RequestPayloadService', false],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => ['privates', 'argument_resolver.query_parameter_value_resolver', 'getArgumentResolver_QueryParameterValueResolverService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => ['privates', 'security.user_value_resolver', 'getSecurity_UserValueResolverService', true],
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => ['privates', 'security.security_token_value_resolver', 'getSecurity_SecurityTokenValueResolverService', true],
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => ['privates', 'doctrine.orm.entity_value_resolver', 'getDoctrine_Orm_EntityValueResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => ['privates', 'argument_resolver.backed_enum_resolver', 'getArgumentResolver_BackedEnumResolverService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\UidValueResolver' => ['privates', 'argument_resolver.uid', 'getArgumentResolver_UidService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => ['privates', 'argument_resolver.datetime', 'getArgumentResolver_DatetimeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => ['privates', 'argument_resolver.request_attribute', 'getArgumentResolver_RequestAttributeService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => ['privates', 'argument_resolver.request', 'getArgumentResolver_RequestService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => ['privates', 'argument_resolver.session', 'getArgumentResolver_SessionService', true],
            'api_platform.argument_resolver.payload' => ['privates', 'api_platform.argument_resolver.payload', 'getApiPlatform_ArgumentResolver_PayloadService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => ['privates', 'argument_resolver.service', 'getArgumentResolver_ServiceService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => ['privates', 'argument_resolver.default', 'getArgumentResolver_DefaultService', true],
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => ['privates', 'argument_resolver.variadic', 'getArgumentResolver_VariadicService', true],
        ], [
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestPayloadValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\QueryParameterValueResolver',
            'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver' => 'Symfony\\Component\\Security\\Http\\Controller\\UserValueResolver',
            'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver' => 'Symfony\\Component\\Security\\Http\\Controller\\SecurityTokenValueResolver',
            'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver' => 'Symfony\\Bridge\\Doctrine\\ArgumentResolver\\EntityValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\BackedEnumValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\UidValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\UidValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DateTimeValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestAttributeValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\RequestValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\SessionValueResolver',
            'api_platform.argument_resolver.payload' => 'ApiPlatform\\Symfony\\Bundle\\ArgumentResolver\\PayloadArgumentResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\ServiceValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\DefaultValueResolver',
            'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver' => 'Symfony\\Component\\HttpKernel\\Controller\\ArgumentResolver\\VariadicValueResolver',
        ])), true);
    }

    /*
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected static function getRequestStackService($container)
    {
        return $container->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /*
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Routing\Router
     */
    protected static function getRouterService($container)
    {
        $a = new \Monolog\Logger('router');
        $a->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $a->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        $container->services['router'] = $instance = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $container), 'kernel::loadRoutes', ['cache_dir' => $container->targetDir.'', 'debug' => false, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => NULL, 'resource_type' => 'service'], ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), $a, 'en');

        $instance->setConfigCacheFactory(($container->privates['config_cache_factory'] ??= new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory()));
        $instance->addExpressionLanguageProvider(($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)));

        return $instance;
    }

    /*
     * Gets the public 'translator' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Translation\Translator
     */
    protected static function getTranslatorService($container)
    {
        $container->services['translator'] = $instance = new \Symfony\Bundle\FrameworkBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
        ], [
            'translation.loader.php' => '?',
            'translation.loader.yml' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.po' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.csv' => '?',
            'translation.loader.res' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
        ]), new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator()), 'en', ['translation.loader.php' => ['php'], 'translation.loader.yml' => ['yaml', 'yml'], 'translation.loader.xliff' => ['xlf', 'xliff'], 'translation.loader.po' => ['po'], 'translation.loader.mo' => ['mo'], 'translation.loader.qt' => ['ts'], 'translation.loader.csv' => ['csv'], 'translation.loader.res' => ['res'], 'translation.loader.dat' => ['dat'], 'translation.loader.ini' => ['ini'], 'translation.loader.json' => ['json']], ['cache_dir' => ($container->targetDir.''.'/translations'), 'debug' => false, 'resource_files' => ['af' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.af.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.af.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.af.xlf')], 'ar' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ar.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ar.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ar.xlf')], 'az' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.az.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.az.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.az.xlf')], 'be' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.be.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.be.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.be.xlf')], 'bg' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.bg.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.bg.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.bg.xlf')], 'bs' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.bs.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.bs.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.bs.xlf')], 'ca' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ca.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ca.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ca.xlf')], 'cs' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.cs.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.cs.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.cs.xlf')], 'cy' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.cy.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.cy.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.cy.xlf')], 'da' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.da.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.da.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.da.xlf')], 'de' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.de.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.de.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.de.xlf')], 'el' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.el.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.el.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.el.xlf')], 'en' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.en.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.en.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.en.xlf')], 'es' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.es.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.es.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.es.xlf')], 'et' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.et.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.et.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.et.xlf')], 'eu' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.eu.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.eu.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.eu.xlf')], 'fa' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.fa.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.fa.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fa.xlf')], 'fi' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.fi.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.fi.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fi.xlf')], 'fr' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.fr.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.fr.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fr.xlf')], 'gl' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.gl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.gl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.gl.xlf')], 'he' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.he.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.he.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.he.xlf')], 'hr' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.hr.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.hr.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hr.xlf')], 'hu' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.hu.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.hu.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hu.xlf')], 'hy' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.hy.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.hy.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hy.xlf')], 'id' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.id.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.id.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.id.xlf')], 'it' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.it.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.it.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.it.xlf')], 'ja' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ja.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ja.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ja.xlf')], 'lb' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.lb.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.lb.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lb.xlf')], 'lt' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.lt.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.lt.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lt.xlf')], 'lv' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.lv.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.lv.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lv.xlf')], 'mk' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.mk.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.mk.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.mk.xlf')], 'mn' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.mn.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.mn.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.mn.xlf')], 'my' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.my.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.my.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.my.xlf')], 'nb' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.nb.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.nb.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nb.xlf')], 'nl' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.nl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.nl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nl.xlf')], 'nn' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.nn.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.nn.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nn.xlf')], 'no' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.no.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.no.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.no.xlf')], 'pl' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.pl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.pl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pl.xlf')], 'pt' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.pt.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.pt.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pt.xlf')], 'pt_BR' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.pt_BR.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.pt_BR.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf')], 'ro' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ro.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ro.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ro.xlf')], 'ru' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ru.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ru.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ru.xlf')], 'sk' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sk.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sk.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sk.xlf')], 'sl' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sl.xlf')], 'sq' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sq.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sq.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sq.xlf')], 'sr_Cyrl' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sr_Cyrl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sr_Cyrl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf')], 'sr_Latn' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sr_Latn.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sr_Latn.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf')], 'sv' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.sv.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.sv.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sv.xlf')], 'th' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.th.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.th.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.th.xlf')], 'tl' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.tl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.tl.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.tl.xlf')], 'tr' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.tr.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.tr.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.tr.xlf')], 'uk' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.uk.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.uk.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.uk.xlf')], 'ur' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.ur.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.ur.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ur.xlf')], 'uz' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.uz.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.uz.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.uz.xlf')], 'vi' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.vi.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.vi.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.vi.xlf')], 'zh_CN' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.zh_CN.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.zh_CN.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf')], 'zh_TW' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations/validators.zh_TW.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations/validators.zh_TW.xlf'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf')]], 'scanned_directories' => [(\dirname(__DIR__, 4).'/vendor/symfony/validator/Resources/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/form/Resources/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations'), (\dirname(__DIR__, 4).'/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/stimulus-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/ux-turbo/translations'), (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle/src/translations'), (\dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/translations'), (\dirname(__DIR__, 4).'/vendor/api-platform/symfony/Bundle/translations'), (\dirname(__DIR__, 4).'/vendor/lexik/jwt-authentication-bundle/translations')], 'cache_vary' => ['scanned_directories' => ['vendor/symfony/validator/Resources/translations', 'vendor/symfony/form/Resources/translations', 'vendor/symfony/security-core/Resources/translations', 'translations', 'vendor/symfony/framework-bundle/translations', 'vendor/doctrine/doctrine-bundle/translations', 'vendor/doctrine/doctrine-migrations-bundle/translations', 'vendor/symfony/twig-bundle/translations', 'vendor/symfony/stimulus-bundle/translations', 'vendor/symfony/ux-turbo/translations', 'vendor/twig/extra-bundle/translations', 'vendor/symfony/security-bundle/translations', 'vendor/symfony/monolog-bundle/src/translations', 'vendor/nelmio/cors-bundle/translations', 'vendor/api-platform/symfony/Bundle/translations', 'vendor/lexik/jwt-authentication-bundle/translations']]], []);

        $instance->setConfigCacheFactory(($container->privates['config_cache_factory'] ??= new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory()));
        $instance->setFallbackLocales(['en']);

        return $instance;
    }

    /*
     * Gets the private '.service_locator.zH94_N9' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function get_ServiceLocator_ZH94N9Service($container)
    {
        return $container->privates['.service_locator.zH94_N9'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'security.firewall.map.context.dev' => ['privates', 'security.firewall.map.context.dev', 'getSecurity_Firewall_Map_Context_DevService', true],
            'security.firewall.map.context.login' => ['privates', 'security.firewall.map.context.login', 'getSecurity_Firewall_Map_Context_LoginService', true],
            'security.firewall.map.context.api' => ['privates', 'security.firewall.map.context.api', 'getSecurity_Firewall_Map_Context_ApiService', true],
            'security.firewall.map.context.main' => ['privates', 'security.firewall.map.context.main', 'getSecurity_Firewall_Map_Context_MainService', true],
        ], [
            'security.firewall.map.context.dev' => '?',
            'security.firewall.map.context.login' => '?',
            'security.firewall.map.context.api' => '?',
            'security.firewall.map.context.main' => '?',
        ]);
    }

    /*
     * Gets the private 'api_platform.hydra.name_converter.hydra_prefix' shared service.
     *
     * @return \ApiPlatform\Hydra\Serializer\HydraPrefixNameConverter
     */
    protected static function getApiPlatform_Hydra_NameConverter_HydraPrefixService($container)
    {
        return $container->privates['api_platform.hydra.name_converter.hydra_prefix'] = new \ApiPlatform\Hydra\Serializer\HydraPrefixNameConverter(($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container)), $container->parameters['api_platform.serializer.default_context']);
    }

    /*
     * Gets the private 'api_platform.jsonld.context_builder' shared service.
     *
     * @return \ApiPlatform\JsonLd\ContextBuilder
     */
    protected static function getApiPlatform_Jsonld_ContextBuilderService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.jsonld.context_builder'])) {
            return $container->privates['api_platform.jsonld.context_builder'];
        }
        $b = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.jsonld.context_builder'])) {
            return $container->privates['api_platform.jsonld.context_builder'];
        }
        $c = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));

        if (isset($container->privates['api_platform.jsonld.context_builder'])) {
            return $container->privates['api_platform.jsonld.context_builder'];
        }

        return $container->privates['api_platform.jsonld.context_builder'] = new \ApiPlatform\JsonLd\ContextBuilder(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), $a, $b, $c, ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)), ($container->privates['api_platform.symfony.iri_converter.skolem'] ?? self::getApiPlatform_Symfony_IriConverter_SkolemService($container)), ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container)), $container->parameters['api_platform.serializer.default_context']);
    }

    /*
     * Gets the private 'api_platform.metadata.operation.metadata_factory' shared service.
     *
     * @return \ApiPlatform\Metadata\Operation\Factory\OperationMetadataFactory
     */
    protected static function getApiPlatform_Metadata_Operation_MetadataFactoryService($container)
    {
        $a = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.metadata.operation.metadata_factory'])) {
            return $container->privates['api_platform.metadata.operation.metadata_factory'];
        }

        return $container->privates['api_platform.metadata.operation.metadata_factory'] = new \ApiPlatform\Metadata\Operation\Factory\OperationMetadataFactory(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)), $a);
    }

    /*
     * Gets the private 'api_platform.metadata.property.metadata_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Property\Factory\CachedPropertyMetadataFactory
     */
    protected static function getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container)
    {
        $a = ($container->privates['validator'] ?? self::getValidatorService($container));

        if (isset($container->privates['api_platform.metadata.property.metadata_factory.cached'])) {
            return $container->privates['api_platform.metadata.property.metadata_factory.cached'];
        }
        $b = ($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container));

        if (isset($container->privates['api_platform.metadata.property.metadata_factory.cached'])) {
            return $container->privates['api_platform.metadata.property.metadata_factory.cached'];
        }
        $c = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        return $container->privates['api_platform.metadata.property.metadata_factory.cached'] = new \ApiPlatform\Metadata\Property\Factory\CachedPropertyMetadataFactory(($container->services['api_platform.cache.metadata.property'] ?? self::getApiPlatform_Cache_Metadata_PropertyService($container)), new \ApiPlatform\JsonSchema\Metadata\Property\Factory\SchemaPropertyMetadataFactory($c, new \ApiPlatform\Symfony\Validator\Metadata\Property\ValidatorPropertyMetadataFactory($a, new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyMetadataFactory(($container->privates['api_platform.metadata.property_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\IdentifierPropertyMetadataFactory($c, new \ApiPlatform\Metadata\Property\Factory\DefaultPropertyMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\SerializerPropertyMetadataFactory(($container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container)), new \ApiPlatform\Metadata\Property\Factory\AttributePropertyMetadataFactory(new \ApiPlatform\Doctrine\Orm\Metadata\Property\DoctrineOrmPropertyMetadataFactory(($container->services['doctrine'] ?? self::getDoctrineService($container)), new \ApiPlatform\Metadata\Property\Factory\PropertyInfoPropertyMetadataFactory($b, new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyMetadataFactory(($container->privates['api_platform.metadata.property_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlPropertyExtractor([], $container)))))), $c)))), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['api_platform.metadata.property_schema.choice_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaChoiceRestriction());
            yield 1 => ($container->privates['api_platform.metadata.property_schema.collection_restriction'] ?? $container->load('getApiPlatform_Metadata_PropertySchema_CollectionRestrictionService'));
            yield 2 => ($container->privates['api_platform.metadata.property_schema.count_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaCountRestriction());
            yield 3 => ($container->privates['api_platform.metadata.property_schema.css_color_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaCssColorRestriction());
            yield 4 => ($container->privates['api_platform.metadata.property_schema.greater_than_or_equal_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaGreaterThanOrEqualRestriction());
            yield 5 => ($container->privates['api_platform.metadata.property_schema.greater_than_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaGreaterThanRestriction());
            yield 6 => ($container->privates['api_platform.metadata.property_schema.length_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLengthRestriction());
            yield 7 => ($container->privates['api_platform.metadata.property_schema.less_than_or_equal_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLessThanOrEqualRestriction());
            yield 8 => ($container->privates['api_platform.metadata.property_schema.less_than_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaLessThanRestriction());
            yield 9 => ($container->privates['api_platform.metadata.property_schema.one_of_restriction'] ?? $container->load('getApiPlatform_Metadata_PropertySchema_OneOfRestrictionService'));
            yield 10 => ($container->privates['api_platform.metadata.property_schema.range_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaRangeRestriction());
            yield 11 => ($container->privates['api_platform.metadata.property_schema.regex_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaRegexRestriction());
            yield 12 => ($container->privates['api_platform.metadata.property_schema.format_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaFormat());
            yield 13 => ($container->privates['api_platform.metadata.property_schema.unique_restriction'] ??= new \ApiPlatform\Symfony\Validator\Metadata\Property\Restriction\PropertySchemaUniqueRestriction());
        }, 14))));
    }

    /*
     * Gets the private 'api_platform.metadata.property.name_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Property\Factory\CachedPropertyNameCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container)
    {
        $a = ($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container));

        if (isset($container->privates['api_platform.metadata.property.name_collection_factory.cached'])) {
            return $container->privates['api_platform.metadata.property.name_collection_factory.cached'];
        }

        return $container->privates['api_platform.metadata.property.name_collection_factory.cached'] = new \ApiPlatform\Metadata\Property\Factory\CachedPropertyNameCollectionFactory(($container->services['api_platform.cache.metadata.property'] ?? self::getApiPlatform_Cache_Metadata_PropertyService($container)), new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyNameCollectionFactory(($container->privates['api_platform.metadata.property_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\ConcernsPropertyNameCollectionMetadataFactory(new \ApiPlatform\Metadata\Property\Factory\ExtractorPropertyNameCollectionFactory(($container->privates['api_platform.metadata.property_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlPropertyExtractor([], $container)), new \ApiPlatform\Metadata\Property\Factory\PropertyInfoPropertyNameCollectionFactory($a)))));
    }

    /*
     * Gets the private 'api_platform.metadata.resource.metadata_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Resource\Factory\CachedResourceMetadataCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container)
    {
        $a = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'])) {
            return $container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'];
        }
        $b = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));

        if (isset($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'])) {
            return $container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'];
        }
        $c = ($container->services['doctrine'] ?? self::getDoctrineService($container));
        $d = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        $e = new \ApiPlatform\Doctrine\Orm\Metadata\Resource\DoctrineOrmLinkFactory($c, $a, $d, new \ApiPlatform\Metadata\Resource\Factory\LinkFactory($a, $b, $d));
        $f = ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container));
        $g = ($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], []));

        return $container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] = new \ApiPlatform\Metadata\Resource\Factory\CachedResourceMetadataCollectionFactory(($container->services['api_platform.cache.metadata.resource_collection'] ?? self::getApiPlatform_Cache_Metadata_ResourceCollectionService($container)), new \ApiPlatform\Doctrine\Orm\Metadata\Resource\DoctrineOrmResourceCollectionMetadataFactory($c, new \ApiPlatform\Symfony\Messenger\Metadata\MessengerResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\PhpDocResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\AlternateUriResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\FiltersResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\FormatsResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\InputOutputResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\OperationNameResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\LinkResourceMetadataCollectionFactory($e, new \ApiPlatform\Metadata\Resource\Factory\MainControllerResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\UriTemplateResourceMetadataCollectionFactory($e, new \ApiPlatform\Metadata\Operation\UnderscorePathSegmentNameGenerator(new \ApiPlatform\Metadata\Util\Inflector()), new \ApiPlatform\Metadata\Resource\Factory\BackedEnumResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\NotExposedOperationResourceMetadataCollectionFactory($e, new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ConcernsResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\MutatorResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Mutator\ResourceMutatorCollection(), new \ApiPlatform\Metadata\Mutator\OperationMutatorCollection(), new \ApiPlatform\Metadata\Resource\Factory\PhpFileResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.php_file'] ??= new \ApiPlatform\Metadata\Extractor\PhpFileResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceMetadataCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlResourceExtractor([], $container)), new \ApiPlatform\Validator\Metadata\Resource\Factory\ParameterValidationResourceMetadataCollectionFactory(new \ApiPlatform\Metadata\Resource\Factory\ParameterResourceMetadataCollectionFactory($a, $b, new \ApiPlatform\Metadata\Resource\Factory\AttributesResourceMetadataCollectionFactory(NULL, $f, $container->parameters['api_platform.defaults'], false), $g, ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container)), $f), $g), $container->parameters['api_platform.defaults'], $f, false), $f, $container->parameters['api_platform.defaults']))), $container->parameters['api_platform.defaults'], $f, false)))), false), false))), $container->parameters['api_platform.formats'], $container->parameters['api_platform.patch_formats'], $container->parameters['api_platform.error_formats'])))))));
    }

    /*
     * Gets the private 'api_platform.metadata.resource.name_collection_factory.cached' shared service.
     *
     * @return \ApiPlatform\Metadata\Resource\Factory\CachedResourceNameCollectionFactory
     */
    protected static function getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)
    {
        return $container->privates['api_platform.metadata.resource.name_collection_factory.cached'] = new \ApiPlatform\Metadata\Resource\Factory\CachedResourceNameCollectionFactory(($container->services['api_platform.cache.metadata.resource'] ?? self::getApiPlatform_Cache_Metadata_ResourceService($container)), new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.yaml'] ??= new \ApiPlatform\Metadata\Extractor\YamlResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ClassNameResourceNameCollectionFactory($container->parameters['api_platform.class_name_resources'], new \ApiPlatform\Metadata\Resource\Factory\AttributesResourceNameCollectionFactory($container->parameters['api_platform.resource_class_directories'], new \ApiPlatform\Metadata\Resource\Factory\ConcernsResourceNameCollectionFactory($container->parameters['api_platform.resource_class_directories'], new \ApiPlatform\Metadata\Resource\Factory\PhpFileResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.php_file'] ??= new \ApiPlatform\Metadata\Extractor\PhpFileResourceExtractor([], $container)), new \ApiPlatform\Metadata\Resource\Factory\ExtractorResourceNameCollectionFactory(($container->privates['api_platform.metadata.resource_extractor.xml'] ??= new \ApiPlatform\Metadata\Extractor\XmlResourceExtractor([], $container)))))))));
    }

    /*
     * Gets the private 'api_platform.resource_class_resolver' shared service.
     *
     * @return \ApiPlatform\Metadata\ResourceClassResolver
     */
    protected static function getApiPlatform_ResourceClassResolverService($container)
    {
        return $container->privates['api_platform.resource_class_resolver'] = new \ApiPlatform\Metadata\ResourceClassResolver(($container->privates['api_platform.metadata.resource.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_NameCollectionFactory_CachedService($container)));
    }

    /*
     * Gets the private 'api_platform.router' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\Router
     */
    protected static function getApiPlatform_RouterService($container)
    {
        $a = ($container->services['router'] ?? self::getRouterService($container));

        if (isset($container->privates['api_platform.router'])) {
            return $container->privates['api_platform.router'];
        }

        return $container->privates['api_platform.router'] = new \ApiPlatform\Symfony\Routing\Router($a, 1);
    }

    /*
     * Gets the private 'api_platform.security.resource_access_checker' shared service.
     *
     * @return \ApiPlatform\Symfony\Security\ResourceAccessChecker
     */
    protected static function getApiPlatform_Security_ResourceAccessCheckerService($container)
    {
        return $container->privates['api_platform.security.resource_access_checker'] = new \ApiPlatform\Symfony\Security\ResourceAccessChecker(($container->privates['security.expression_language'] ?? self::getSecurity_ExpressionLanguageService($container)), ($container->privates['security.authentication.trust_resolver'] ??= new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver()), ($container->privates['security.role_hierarchy'] ?? self::getSecurity_RoleHierarchyService($container)), ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), ($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container)), false);
    }

    /*
     * Gets the private 'api_platform.serializer.mapping.cache_class_metadata_factory' shared service.
     *
     * @return \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory
     */
    protected static function getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container)
    {
        $a = \Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($container->targetDir.''.'/serialization.php'), ($container->privates['cache.serializer'] ?? self::getCache_SerializerService($container)));

        return $container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] = new \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory(new \ApiPlatform\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Factory\CacheClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Factory\ClassMetadataFactory(new \Symfony\Component\Serializer\Mapping\Loader\LoaderChain([($container->privates['serializer.mapping.attribute_loader'] ??= new \Symfony\Component\Serializer\Mapping\Loader\AttributeLoader(true, []))])), $a)), $a);
    }

    /*
     * Gets the private 'api_platform.state_provider.locator' shared service.
     *
     * @return \ApiPlatform\State\CallableProvider
     */
    protected static function getApiPlatform_StateProvider_LocatorService($container)
    {
        return $container->privates['api_platform.state_provider.locator'] = new \ApiPlatform\State\CallableProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'ApiPlatform\\State\\CreateProvider' => ['privates', 'api_platform.state_provider.create', 'getApiPlatform_StateProvider_CreateService', true],
            'ApiPlatform\\State\\ObjectProvider' => ['privates', 'api_platform.state_provider.object', 'getApiPlatform_StateProvider_ObjectService', true],
            'ApiPlatform\\State\\Provider\\BackedEnumProvider' => ['privates', 'api_platform.state_provider.backed_enum', 'getApiPlatform_StateProvider_BackedEnumService', true],
            'api_platform.state.error_provider' => ['privates', 'api_platform.state.error_provider', 'getApiPlatform_State_ErrorProviderService', true],
            'api_platform.validator.state.error_provider' => ['privates', 'api_platform.validator.state.error_provider', 'getApiPlatform_Validator_State_ErrorProviderService', true],
            'api_platform.state_provider.create' => ['privates', 'api_platform.state_provider.create', 'getApiPlatform_StateProvider_CreateService', true],
            'api_platform.state_provider.object' => ['privates', 'api_platform.state_provider.object', 'getApiPlatform_StateProvider_ObjectService', true],
            'api_platform.state_provider.backed_enum' => ['privates', 'api_platform.state_provider.backed_enum', 'getApiPlatform_StateProvider_BackedEnumService', true],
            'ApiPlatform\\OpenApi\\State\\OpenApiProvider' => ['privates', 'api_platform.openapi.provider', 'getApiPlatform_Openapi_ProviderService', true],
            'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider' => ['privates', 'api_platform.doctrine.orm.state.collection_provider', 'getApiPlatform_Doctrine_Orm_State_CollectionProviderService', true],
            'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider' => ['privates', 'api_platform.doctrine.orm.state.item_provider', 'getApiPlatform_Doctrine_Orm_State_ItemProviderService', true],
            'api_platform.openapi.provider' => ['privates', 'api_platform.openapi.provider', 'getApiPlatform_Openapi_ProviderService', true],
            'api_platform.doctrine.orm.state.collection_provider' => ['privates', 'api_platform.doctrine.orm.state.collection_provider', 'getApiPlatform_Doctrine_Orm_State_CollectionProviderService', true],
            'api_platform.doctrine.orm.state.item_provider' => ['privates', 'api_platform.doctrine.orm.state.item_provider', 'getApiPlatform_Doctrine_Orm_State_ItemProviderService', true],
        ], [
            'ApiPlatform\\State\\CreateProvider' => 'ApiPlatform\\State\\CreateProvider',
            'ApiPlatform\\State\\ObjectProvider' => 'ApiPlatform\\State\\ObjectProvider',
            'ApiPlatform\\State\\Provider\\BackedEnumProvider' => 'ApiPlatform\\State\\Provider\\BackedEnumProvider',
            'api_platform.state.error_provider' => 'ApiPlatform\\State\\ErrorProvider',
            'api_platform.validator.state.error_provider' => 'ApiPlatform\\Symfony\\Validator\\State\\ErrorProvider',
            'api_platform.state_provider.create' => 'ApiPlatform\\State\\CreateProvider',
            'api_platform.state_provider.object' => 'ApiPlatform\\State\\ObjectProvider',
            'api_platform.state_provider.backed_enum' => 'ApiPlatform\\State\\Provider\\BackedEnumProvider',
            'ApiPlatform\\OpenApi\\State\\OpenApiProvider' => 'ApiPlatform\\OpenApi\\State\\OpenApiProvider',
            'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider' => 'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider',
            'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider' => 'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider',
            'api_platform.openapi.provider' => 'ApiPlatform\\OpenApi\\State\\OpenApiProvider',
            'api_platform.doctrine.orm.state.collection_provider' => 'ApiPlatform\\Doctrine\\Orm\\State\\CollectionProvider',
            'api_platform.doctrine.orm.state.item_provider' => 'ApiPlatform\\Doctrine\\Orm\\State\\ItemProvider',
        ]));
    }

    /*
     * Gets the private 'api_platform.symfony.iri_converter' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\IriConverter
     */
    protected static function getApiPlatform_Symfony_IriConverterService($container)
    {
        $a = ($container->privates['api_platform.state_provider.locator'] ?? self::getApiPlatform_StateProvider_LocatorService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $b = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $c = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $d = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $e = ($container->privates['api_platform.uri_variables.converter'] ?? self::getApiPlatform_UriVariables_ConverterService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $f = ($container->privates['api_platform.metadata.operation.metadata_factory'] ?? self::getApiPlatform_Metadata_Operation_MetadataFactoryService($container));

        if (isset($container->privates['api_platform.symfony.iri_converter'])) {
            return $container->privates['api_platform.symfony.iri_converter'];
        }
        $g = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));

        return $container->privates['api_platform.symfony.iri_converter'] = new \ApiPlatform\Symfony\Routing\IriConverter($a, ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)), new \ApiPlatform\Metadata\IdentifiersExtractor($b, $g, $c, $d, ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container))), $g, $b, $e, ($container->privates['api_platform.symfony.iri_converter.skolem'] ?? self::getApiPlatform_Symfony_IriConverter_SkolemService($container)), $f);
    }

    /*
     * Gets the private 'api_platform.symfony.iri_converter.skolem' shared service.
     *
     * @return \ApiPlatform\Symfony\Routing\SkolemIriConverter
     */
    protected static function getApiPlatform_Symfony_IriConverter_SkolemService($container)
    {
        return $container->privates['api_platform.symfony.iri_converter.skolem'] = new \ApiPlatform\Symfony\Routing\SkolemIriConverter(($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container)));
    }

    /*
     * Gets the private 'api_platform.uri_variables.converter' shared service.
     *
     * @return \ApiPlatform\Metadata\UriVariablesConverter
     */
    protected static function getApiPlatform_UriVariables_ConverterService($container)
    {
        $a = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));

        if (isset($container->privates['api_platform.uri_variables.converter'])) {
            return $container->privates['api_platform.uri_variables.converter'];
        }
        $b = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['api_platform.uri_variables.converter'])) {
            return $container->privates['api_platform.uri_variables.converter'];
        }

        return $container->privates['api_platform.uri_variables.converter'] = new \ApiPlatform\Metadata\UriVariablesConverter($a, $b, new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['api_platform.symfony.uri_variables.transformer.ulid'] ??= new \ApiPlatform\Symfony\UriVariableTransformer\UlidUriVariableTransformer());
            yield 1 => ($container->privates['api_platform.symfony.uri_variables.transformer.uuid'] ??= new \ApiPlatform\Symfony\UriVariableTransformer\UuidUriVariableTransformer());
            yield 2 => ($container->privates['api_platform.uri_variables.transformer.integer'] ??= new \ApiPlatform\Metadata\UriVariableTransformer\IntegerUriVariableTransformer());
            yield 3 => ($container->privates['api_platform.uri_variables.transformer.date_time'] ??= new \ApiPlatform\Metadata\UriVariableTransformer\DateTimeUriVariableTransformer());
        }, 4));
    }

    /*
     * Gets the private 'argument_resolver.request_payload' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestPayloadValueResolver
     */
    protected static function getArgumentResolver_RequestPayloadService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['argument_resolver.request_payload'] = $container->createProxy('RequestPayloadValueResolverGhostB9dbeab', static fn () => \RequestPayloadValueResolverGhostB9dbeab::createLazyGhost(static fn ($proxy) => self::getArgumentResolver_RequestPayloadService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->privates['validator'] ?? self::getValidatorService($container)), ($container->services['translator'] ?? self::getTranslatorService($container)), 'validators') && false ?: $lazyLoad);
    }

    /*
     * Gets the private 'cache.property_access' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PropertyAccessService($container)
    {
        return $container->privates['cache.property_access'] = \Symfony\Component\PropertyAccess\PropertyAccessor::createCache('Fqrb0aPQ3j', 0, $container->getParameter('container.build_id'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.property_info' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PropertyInfoService($container)
    {
        return $container->privates['cache.property_info'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('TK9suas9uE', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.security_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SecurityExpressionLanguageService($container)
    {
        return $container->privates['cache.security_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('70O6hUllAT', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.serializer' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SerializerService($container)
    {
        return $container->privates['cache.serializer'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('5UK3SYUyWH', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'cache.validator' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_ValidatorService($container)
    {
        return $container->privates['cache.validator'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('Zuhli+ku6v', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'controller.is_csrf_token_valid_attribute_listener' shared service.
     *
     * @return \Symfony\Component\Security\Http\EventListener\IsCsrfTokenValidAttributeListener
     */
    protected static function getController_IsCsrfTokenValidAttributeListenerService($container)
    {
        return $container->privates['controller.is_csrf_token_valid_attribute_listener'] = new \Symfony\Component\Security\Http\EventListener\IsCsrfTokenValidAttributeListener(($container->privates['security.csrf.same_origin_token_manager'] ?? self::getSecurity_Csrf_SameOriginTokenManagerService($container)), new \Symfony\Component\ExpressionLanguage\ExpressionLanguage(($container->services['cache.security_is_csrf_token_valid_attribute_expression_language'] ?? self::getCache_SecurityIsCsrfTokenValidAttributeExpressionLanguageService($container))));
    }

    /*
     * Gets the private 'controller.is_granted_attribute_listener' shared service.
     *
     * @return \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener
     */
    protected static function getController_IsGrantedAttributeListenerService($container)
    {
        return $container->privates['controller.is_granted_attribute_listener'] = new \Symfony\Component\Security\Http\EventListener\IsGrantedAttributeListener(($container->privates['security.authorization_checker'] ?? self::getSecurity_AuthorizationCheckerService($container)), new \Symfony\Component\ExpressionLanguage\ExpressionLanguage(($container->services['cache.security_is_granted_attribute_expression_language'] ?? self::getCache_SecurityIsGrantedAttributeExpressionLanguageService($container))));
    }

    /*
     * Gets the private 'controller.is_signature_valid_attribute_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\IsSignatureValidAttributeListener
     */
    protected static function getController_IsSignatureValidAttributeListenerService($container)
    {
        return $container->privates['controller.is_signature_valid_attribute_listener'] = new \Symfony\Component\HttpKernel\EventListener\IsSignatureValidAttributeListener(($container->privates['uri_signer'] ?? self::getUriSignerService($container)));
    }

    /*
     * Gets the private 'doctrine.dbal.default_connection.event_manager' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\ContainerAwareEventManager
     */
    protected static function getDoctrine_Dbal_DefaultConnection_EventManagerService($container)
    {
        return $container->privates['doctrine.dbal.default_connection.event_manager'] = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'doctrine.orm.messenger.doctrine_schema_listener' => ['privates', 'doctrine.orm.messenger.doctrine_schema_listener', 'getDoctrine_Orm_Messenger_DoctrineSchemaListenerService', true],
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineDbalCacheAdapterSchemaListenerService', true],
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => ['privates', 'doctrine.orm.listeners.doctrine_token_provider_schema_listener', 'getDoctrine_Orm_Listeners_DoctrineTokenProviderSchemaListenerService', true],
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => ['privates', 'doctrine.orm.listeners.pdo_session_handler_schema_listener', 'getDoctrine_Orm_Listeners_PdoSessionHandlerSchemaListenerService', true],
            'doctrine.orm.listeners.lock_store_schema_listener' => ['privates', 'doctrine.orm.listeners.lock_store_schema_listener', 'getDoctrine_Orm_Listeners_LockStoreSchemaListenerService', true],
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'turbo.doctrine.event_listener' => ['privates', 'turbo.doctrine.event_listener', 'getTurbo_Doctrine_EventListenerService', true],
        ], [
            'doctrine.orm.messenger.doctrine_schema_listener' => '?',
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener' => '?',
            'doctrine.orm.listeners.doctrine_token_provider_schema_listener' => '?',
            'doctrine.orm.listeners.pdo_session_handler_schema_listener' => '?',
            'doctrine.orm.listeners.lock_store_schema_listener' => '?',
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'turbo.doctrine.event_listener' => '?',
        ]), [[['postGenerateSchema'], 'doctrine.orm.messenger.doctrine_schema_listener'], [['onSchemaCreateTable'], 'doctrine.orm.messenger.doctrine_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.doctrine_token_provider_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.pdo_session_handler_schema_listener'], [['postGenerateSchema'], 'doctrine.orm.listeners.lock_store_schema_listener'], [['loadClassMetadata'], 'doctrine.orm.default_listeners.attach_entity_listeners'], [['onFlush'], 'turbo.doctrine.event_listener'], [['postFlush'], 'turbo.doctrine.event_listener']]);
    }

    /*
     * Gets the private 'doctrine.dbal.idle_connection_listener' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\Middleware\IdleConnection\Listener
     */
    protected static function getDoctrine_Dbal_IdleConnectionListenerService($container)
    {
        return $container->privates['doctrine.dbal.idle_connection_listener'] = new \Symfony\Bridge\Doctrine\Middleware\IdleConnection\Listener(($container->privates['doctrine.dbal.connection_expiries'] ??= new \ArrayObject()), $container);
    }

    /*
     * Gets the private 'doctrine.orm.default_configuration' shared service.
     *
     * @return \Doctrine\ORM\Configuration
     */
    protected static function getDoctrine_Orm_DefaultConfigurationService($container)
    {
        $container->privates['doctrine.orm.default_configuration'] = $instance = new \Doctrine\ORM\Configuration();

        $a = new \Doctrine\Persistence\Mapping\Driver\MappingDriverChain();
        $a->addDriver(new \Doctrine\ORM\Mapping\Driver\AttributeDriver([(\dirname(__DIR__, 4).'/src/Entity')], true), 'App\\Entity');

        $instance->setEntityNamespaces(['App' => 'App\\Entity']);
        $instance->setMetadataCache(new \Symfony\Component\Cache\Adapter\PhpArrayAdapter(($container->targetDir.''.'/doctrine/orm/default_metadata.php'), new \Symfony\Component\Cache\Adapter\ArrayAdapter()));
        $instance->setQueryCache(($container->privates['doctrine.system_cache_pool'] ?? self::getDoctrine_SystemCachePoolService($container)));
        $instance->setResultCache(($container->privates['doctrine.result_cache_pool'] ?? self::getDoctrine_ResultCachePoolService($container)));
        $instance->setMetadataDriverImpl(new \Doctrine\Bundle\DoctrineBundle\Mapping\MappingDriver($a, new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'doctrine.ulid_generator' => ['privates', 'doctrine.ulid_generator', 'getDoctrine_UlidGeneratorService', true],
            'doctrine.uuid_generator' => ['privates', 'doctrine.uuid_generator', 'getDoctrine_UuidGeneratorService', true],
        ], [
            'doctrine.ulid_generator' => '?',
            'doctrine.uuid_generator' => '?',
        ])));
        $instance->setProxyDir(($container->targetDir.''.'/doctrine/orm/Proxies'));
        $instance->setProxyNamespace('Proxies');
        $instance->setAutoGenerateProxyClasses(false);
        $instance->setSchemaIgnoreClasses([]);
        $instance->setClassMetadataFactoryName('Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ClassMetadataFactory');
        $instance->setDefaultRepositoryClassName('Doctrine\\ORM\\EntityRepository');
        $instance->setNamingStrategy(new \Doctrine\ORM\Mapping\UnderscoreNamingStrategy(0, true));
        $instance->setQuoteStrategy(new \Doctrine\ORM\Mapping\DefaultQuoteStrategy());
        $instance->setTypedFieldMapper(new \Doctrine\ORM\Mapping\DefaultTypedFieldMapper());
        $instance->setEntityListenerResolver(new \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver($container));
        $instance->setLazyGhostObjectEnabled(true);
        $instance->setIdentityGenerationPreferences(['Doctrine\\DBAL\\Platforms\\PostgreSQLPlatform' => 4]);
        $instance->setRepositoryFactory(new \Doctrine\Bundle\DoctrineBundle\Repository\ContainerRepositoryFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'App\\Repository\\ExamRepository' => ['privates', 'App\\Repository\\ExamRepository', 'getExamRepositoryService', true],
            'App\\Repository\\PracticeTestRepository' => ['privates', 'App\\Repository\\PracticeTestRepository', 'getPracticeTestRepositoryService', true],
            'App\\Repository\\QuestionRepository' => ['privates', 'App\\Repository\\QuestionRepository', 'getQuestionRepositoryService', true],
            'App\\Repository\\SubjectRepository' => ['privates', 'App\\Repository\\SubjectRepository', 'getSubjectRepositoryService', true],
            'App\\Repository\\SubscriptionRepository' => ['privates', 'App\\Repository\\SubscriptionRepository', 'getSubscriptionRepositoryService', true],
            'App\\Repository\\TopicRepository' => ['privates', 'App\\Repository\\TopicRepository', 'getTopicRepositoryService', true],
            'App\\Repository\\TransactionRepository' => ['privates', 'App\\Repository\\TransactionRepository', 'getTransactionRepositoryService', true],
            'App\\Repository\\UserRepository' => ['privates', 'App\\Repository\\UserRepository', 'getUserRepositoryService', true],
        ], [
            'App\\Repository\\ExamRepository' => '?',
            'App\\Repository\\PracticeTestRepository' => '?',
            'App\\Repository\\QuestionRepository' => '?',
            'App\\Repository\\SubjectRepository' => '?',
            'App\\Repository\\SubscriptionRepository' => '?',
            'App\\Repository\\TopicRepository' => '?',
            'App\\Repository\\TransactionRepository' => '?',
            'App\\Repository\\UserRepository' => '?',
        ])));

        return $instance;
    }

    /*
     * Gets the private 'doctrine.result_cache_pool' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getDoctrine_ResultCachePoolService($container)
    {
        $container->privates['doctrine.result_cache_pool'] = $instance = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('mcNKTO63YL', 0, (\dirname(__DIR__, 3).'/share/prod/pools/app'), ($container->privates['cache.default_marshaller'] ??= new \Symfony\Component\Cache\Marshaller\DefaultMarshaller(NULL, false)));

        $instance->setLogger(($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));

        return $instance;
    }

    /*
     * Gets the private 'doctrine.system_cache_pool' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getDoctrine_SystemCachePoolService($container)
    {
        return $container->privates['doctrine.system_cache_pool'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('oMYZI4Lk5I', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected static function getExceptionListenerService($container)
    {
        return $container->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), false, [], []);
    }

    /*
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected static function getLocaleAwareListenerService($container)
    {
        return $container->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['slugger'] ??= new \Symfony\Component\String\Slugger\AsciiSlugger('en'));
            yield 1 => ($container->services['translator'] ?? self::getTranslatorService($container));
            yield 2 => ($container->privates['translation.locale_switcher'] ?? $container->load('getTranslation_LocaleSwitcherService'));
        }, 3), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected static function getLocaleListenerService($container)
    {
        return $container->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), 'en', ($container->services['router'] ?? self::getRouterService($container)), false, []);
    }

    /*
     * Gets the private 'mime_types' shared service.
     *
     * @return \Symfony\Component\Mime\MimeTypes
     */
    protected static function getMimeTypesService($container)
    {
        $container->privates['mime_types'] = $instance = new \Symfony\Component\Mime\MimeTypes();

        $instance->setDefault($instance);

        return $instance;
    }

    /*
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected static function getMonolog_Handler_ConsoleService($container)
    {
        return $container->privates['monolog.handler.console'] = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], [], false);
    }

    /*
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\FingersCrossedHandler
     */
    protected static function getMonolog_Handler_MainService($container)
    {
        $a = new \Monolog\Handler\StreamHandler('php://stderr', 'debug', true, NULL, false);
        $a->pushProcessor(($container->privates['monolog.processor.psr_log_message'] ??= new \Monolog\Processor\PsrLogMessageProcessor()));
        $a->setFormatter(($container->privates['monolog.formatter.json'] ??= new \Monolog\Formatter\JsonFormatter()));

        return $container->privates['monolog.handler.main'] = new \Monolog\Handler\FingersCrossedHandler($a, new \Symfony\Bridge\Monolog\Handler\FingersCrossed\HttpCodeActivationStrategy(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), [['code' => 404, 'urls' => []], ['code' => 405, 'urls' => []]], new \Monolog\Handler\FingersCrossed\ErrorLevelActivationStrategy('error')), 50, true, true, NULL);
    }

    /*
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_LoggerService($container)
    {
        $container->privates['monolog.logger'] = $instance = new \Monolog\Logger('app');

        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.cache' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_Logger_CacheService($container)
    {
        $container->privates['monolog.logger.cache'] = $instance = new \Monolog\Logger('cache');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_Logger_RequestService($container)
    {
        $container->privates['monolog.logger.request'] = $instance = new \Monolog\Logger('request');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.security' shared service.
     *
     * @return \Monolog\Logger
     */
    protected static function getMonolog_Logger_SecurityService($container)
    {
        $container->privates['monolog.logger.security'] = $instance = new \Monolog\Logger('security');

        $instance->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $instance->pushHandler(($container->privates['monolog.handler.main'] ?? self::getMonolog_Handler_MainService($container)));

        return $instance;
    }

    /*
     * Gets the private 'nelmio_cors.cors_listener' shared service.
     *
     * @return \Nelmio\CorsBundle\EventListener\CorsListener
     */
    protected static function getNelmioCors_CorsListenerService($container)
    {
        return $container->privates['nelmio_cors.cors_listener'] = new \Nelmio\CorsBundle\EventListener\CorsListener(new \Nelmio\CorsBundle\Options\Resolver([new \Nelmio\CorsBundle\Options\ConfigProvider($container->parameters['nelmio_cors.map'], $container->getParameter('nelmio_cors.defaults'))]));
    }

    /*
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected static function getParameterBagService($container)
    {
        return $container->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container);
    }

    /*
     * Gets the private 'property_accessor' shared service.
     *
     * @return \Symfony\Component\PropertyAccess\PropertyAccessor
     */
    protected static function getPropertyAccessorService($container)
    {
        $a = ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());

        return $container->privates['property_accessor'] = new \Symfony\Component\PropertyAccess\PropertyAccessor(3, 2, ($container->privates['cache.property_access'] ?? self::getCache_PropertyAccessService($container)), $a, $a);
    }

    /*
     * Gets the private 'property_info.cache' shared service.
     *
     * @return \Symfony\Component\PropertyInfo\PropertyInfoCacheExtractor
     */
    protected static function getPropertyInfo_CacheService($container)
    {
        return $container->privates['property_info.cache'] = new \Symfony\Component\PropertyInfo\PropertyInfoCacheExtractor(new \Symfony\Component\PropertyInfo\PropertyInfoExtractor(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.serializer_extractor'] ?? $container->load('getPropertyInfo_SerializerExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
            yield 2 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
        }, 3), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.constructor_extractor'] ?? $container->load('getPropertyInfo_ConstructorExtractorService'));
            yield 1 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 2 => ($container->privates['property_info.phpstan_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpStanExtractor());
            yield 3 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
            yield 4 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 5), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.php_doc_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor());
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['doctrine.orm.default_entity_manager.property_info_extractor'] ?? $container->load('getDoctrine_Orm_DefaultEntityManager_PropertyInfoExtractorService'));
            yield 1 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 2), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['property_info.reflection_extractor'] ??= new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor());
        }, 1)), ($container->privates['cache.property_info'] ?? self::getCache_PropertyInfoService($container)));
    }

    /*
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected static function getRouter_ExpressionLanguageProviderService($container)
    {
        return $container->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
            'service' => ['services', 'container.get_routing_condition_service', 'getContainer_GetRoutingConditionServiceService', true],
        ], [
            'env' => 'Closure',
            'service' => 'Closure',
        ]));
    }

    /*
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected static function getRouter_RequestContextService($container)
    {
        $container->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri($container->getEnv('DEFAULT_URI'), 'localhost', 'http', 80, 443);

        $instance->setParameters(['_functions' => ($container->privates['router.expression_language_provider'] ?? self::getRouter_ExpressionLanguageProviderService($container)), '_locale' => 'en']);

        return $instance;
    }

    /*
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected static function getRouterListenerService($container)
    {
        return $container->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener(($container->services['router'] ?? self::getRouterService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container)), ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), \dirname(__DIR__, 4), false);
    }

    /*
     * Gets the private 'security.access.decision_manager' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AccessDecisionManager
     */
    protected static function getSecurity_Access_DecisionManagerService($container)
    {
        return $container->privates['security.access.decision_manager'] = new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.access.authenticated_voter'] ?? $container->load('getSecurity_Access_AuthenticatedVoterService'));
            yield 1 => ($container->privates['security.access.role_hierarchy_voter'] ?? $container->load('getSecurity_Access_RoleHierarchyVoterService'));
            yield 2 => ($container->privates['security.access.expression_voter'] ?? $container->load('getSecurity_Access_ExpressionVoterService'));
            yield 3 => ($container->privates['security.access.closure_voter'] ?? $container->load('getSecurity_Access_ClosureVoterService'));
        }, 4), new \Symfony\Component\Security\Core\Authorization\Strategy\AffirmativeStrategy(false));
    }

    /*
     * Gets the private 'security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected static function getSecurity_AuthorizationCheckerService($container)
    {
        $a = ($container->privates['security.access.decision_manager'] ?? self::getSecurity_Access_DecisionManagerService($container));

        if (isset($container->privates['security.authorization_checker'])) {
            return $container->privates['security.authorization_checker'];
        }

        return $container->privates['security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), $a);
    }

    /*
     * Gets the private 'security.context_listener.0' shared service.
     *
     * @return \Symfony\Component\Security\Http\Firewall\ContextListener
     */
    protected static function getSecurity_ContextListener_0Service($container)
    {
        return $container->privates['security.context_listener.0'] = new \Symfony\Component\Security\Http\Firewall\ContextListener(($container->privates['security.untracked_token_storage'] ??= new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage()), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['security.user.provider.concrete.app_user_provider'] ?? $container->load('getSecurity_User_Provider_Concrete_AppUserProviderService'));
        }, 1), 'main', ($container->privates['monolog.logger.security'] ?? self::getMonolog_Logger_SecurityService($container)), ($container->privates['security.event_dispatcher.main'] ?? self::getSecurity_EventDispatcher_MainService($container)), ($container->privates['security.authentication.trust_resolver'] ??= new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver()), [($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)), 'enableUsageTracking']);
    }

    /*
     * Gets the private 'security.csrf.same_origin_token_manager' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\SameOriginCsrfTokenManager
     */
    protected static function getSecurity_Csrf_SameOriginTokenManagerService($container)
    {
        $a = ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack());

        return $container->privates['security.csrf.same_origin_token_manager'] = new \Symfony\Component\Security\Csrf\SameOriginCsrfTokenManager($a, ($container->privates['monolog.logger.request'] ?? self::getMonolog_Logger_RequestService($container)), new \Symfony\Component\Security\Csrf\CsrfTokenManager(new \Symfony\Component\Security\Csrf\TokenGenerator\UriSafeTokenGenerator(), ($container->privates['security.csrf.token_storage'] ?? self::getSecurity_Csrf_TokenStorageService($container)), $a), ['submit', 'authenticate', 'logout'], true, 'csrf-token');
    }

    /*
     * Gets the private 'security.csrf.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage
     */
    protected static function getSecurity_Csrf_TokenStorageService($container)
    {
        return $container->privates['security.csrf.token_storage'] = new \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the private 'security.event_dispatcher.main' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected static function getSecurity_EventDispatcher_MainService($container)
    {
        $container->privates['security.event_dispatcher.main'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.session.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\SessionStrategyListener')] fn () => ($container->privates['security.listener.session.main'] ?? $container->load('getSecurity_Listener_Session_MainService')), 'onSuccessfulLogin'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_checker.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserCheckerListener')] fn () => ($container->privates['security.listener.user_checker.main'] ?? $container->load('getSecurity_Listener_UserChecker_MainService')), 'preCheckCredentials'], 256);
        $instance->addListener('security.authentication.success', [#[\Closure(name: 'security.listener.user_checker.main', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserCheckerListener')] fn () => ($container->privates['security.listener.user_checker.main'] ?? $container->load('getSecurity_Listener_UserChecker_MainService')), 'postCheckCredentials'], 256);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.user_provider', class: 'Symfony\\Component\\Security\\Http\\EventListener\\UserProviderListener')] fn () => ($container->privates['security.listener.user_provider'] ?? $container->load('getSecurity_Listener_UserProviderService')), 'checkPassport'], 1024);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.check_authenticator_credentials', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CheckCredentialsListener')] fn () => ($container->privates['security.listener.check_authenticator_credentials'] ?? $container->load('getSecurity_Listener_CheckAuthenticatorCredentialsService')), 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [#[\Closure(name: 'security.listener.password_migrating', class: 'Symfony\\Component\\Security\\Http\\EventListener\\PasswordMigratingListener')] fn () => ($container->privates['security.listener.password_migrating'] ?? $container->load('getSecurity_Listener_PasswordMigratingService')), 'onLoginSuccess'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [#[\Closure(name: 'security.listener.csrf_protection', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfProtectionListener')] fn () => ($container->privates['security.listener.csrf_protection'] ?? $container->load('getSecurity_Listener_CsrfProtectionService')), 'checkPassport'], 512);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [#[\Closure(name: 'security.logout.listener.csrf_token_clearing', class: 'Symfony\\Component\\Security\\Http\\EventListener\\CsrfTokenClearingLogoutListener')] fn () => ($container->privates['security.logout.listener.csrf_token_clearing'] ?? $container->load('getSecurity_Logout_Listener_CsrfTokenClearingService')), 'onLogout'], 0);

        return $instance;
    }

    /*
     * Gets the private 'security.expression_language' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\ExpressionLanguage
     */
    protected static function getSecurity_ExpressionLanguageService($container)
    {
        $container->privates['security.expression_language'] = $instance = new \Symfony\Component\Security\Core\Authorization\ExpressionLanguage(($container->privates['cache.security_expression_language'] ?? self::getCache_SecurityExpressionLanguageService($container)));

        $instance->registerProvider(new \ApiPlatform\Symfony\Security\Core\Authorization\ExpressionLanguageProvider());

        return $instance;
    }

    /*
     * Gets the private 'security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener
     */
    protected static function getSecurity_FirewallService($container)
    {
        $a = ($container->privates['security.firewall.map'] ?? self::getSecurity_Firewall_MapService($container));

        if (isset($container->privates['security.firewall'])) {
            return $container->privates['security.firewall'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->privates['security.firewall'])) {
            return $container->privates['security.firewall'];
        }

        return $container->privates['security.firewall'] = new \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener($a, $b, ($container->privates['security.logout_url_generator'] ?? self::getSecurity_LogoutUrlGeneratorService($container)));
    }

    /*
     * Gets the private 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected static function getSecurity_Firewall_MapService($container)
    {
        $a = ($container->privates['.service_locator.zH94_N9'] ?? self::get_ServiceLocator_ZH94N9Service($container));

        if (isset($container->privates['security.firewall.map'])) {
            return $container->privates['security.firewall.map'];
        }

        return $container->privates['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap($a, new RewindableGenerator(function () use ($container) {
            yield 'security.firewall.map.context.dev' => ($container->privates['.security.request_matcher.gOpgIHx'] ?? $container->load('get_Security_RequestMatcher_GOpgIHxService'));
            yield 'security.firewall.map.context.login' => ($container->privates['.security.request_matcher._7JLSkp'] ?? $container->load('get_Security_RequestMatcher_7JLSkpService'));
            yield 'security.firewall.map.context.api' => ($container->privates['.security.request_matcher.NaFk5J1'] ?? $container->load('get_Security_RequestMatcher_NaFk5J1Service'));
            yield 'security.firewall.map.context.main' => NULL;
        }, 4));
    }

    /*
     * Gets the private 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected static function getSecurity_LogoutUrlGeneratorService($container)
    {
        $a = ($container->services['router'] ?? self::getRouterService($container));

        if (isset($container->privates['security.logout_url_generator'])) {
            return $container->privates['security.logout_url_generator'];
        }

        return $container->privates['security.logout_url_generator'] = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), $a, ($container->privates['security.token_storage'] ?? self::getSecurity_TokenStorageService($container)));
    }

    /*
     * Gets the private 'security.role_hierarchy' shared service.
     *
     * @return \Symfony\Component\Security\Core\Role\RoleHierarchy
     */
    protected static function getSecurity_RoleHierarchyService($container)
    {
        return $container->privates['security.role_hierarchy'] = new \Symfony\Component\Security\Core\Role\RoleHierarchy($container->parameters['security.role_hierarchy.roles']);
    }

    /*
     * Gets the private 'security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected static function getSecurity_TokenStorageService($container)
    {
        return $container->privates['security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(($container->privates['security.untracked_token_storage'] ??= new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage()), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'request_stack' => '?',
        ]));
    }

    /*
     * Gets the private 'serializer' shared service.
     *
     * @return \Symfony\Component\Serializer\Serializer
     */
    protected static function getSerializerService($container)
    {
        $a = ($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $b = ($container->privates['api_platform.metadata.resource.metadata_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Resource_MetadataCollectionFactory_CachedService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $c = ($container->privates['api_platform.metadata.property.name_collection_factory.cached'] ?? self::getApiPlatform_Metadata_Property_NameCollectionFactory_CachedService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $d = ($container->privates['api_platform.metadata.property.metadata_factory.cached'] ?? self::getApiPlatform_Metadata_Property_MetadataFactory_CachedService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $e = ($container->privates['api_platform.symfony.iri_converter'] ?? self::getApiPlatform_Symfony_IriConverterService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $f = ($container->privates['api_platform.jsonld.context_builder'] ?? self::getApiPlatform_Jsonld_ContextBuilderService($container));

        if (isset($container->privates['serializer'])) {
            return $container->privates['serializer'];
        }
        $g = ($container->privates['property_accessor'] ?? self::getPropertyAccessorService($container));
        $h = new \Symfony\Component\Serializer\Encoder\JsonEncoder(NULL, NULL, $container->parameters['api_platform.serializer.default_context']);

        $i = new \ApiPlatform\OpenApi\Serializer\LegacyOpenApiNormalizer(new \ApiPlatform\OpenApi\Serializer\ApiGatewayNormalizer(new \ApiPlatform\OpenApi\Serializer\OpenApiNormalizer(new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer(NULL, NULL, $g, $a)], [$h])), $container->parameters['api_platform.serializer.default_context']), $container->parameters['api_platform.serializer.default_context']);
        $j = ($container->privates['api_platform.hydra.name_converter.hydra_prefix'] ?? self::getApiPlatform_Hydra_NameConverter_HydraPrefixService($container));
        $k = ($container->privates['api_platform.resource_class_resolver'] ?? self::getApiPlatform_ResourceClassResolverService($container));
        $l = ($container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container));
        $m = ($container->privates['api_platform.security.resource_access_checker'] ?? self::getApiPlatform_Security_ResourceAccessCheckerService($container));

        $n = new \ApiPlatform\JsonLd\Serializer\ItemNormalizer($b, $c, $d, $e, $k, $f, $g, $j, $l, $container->parameters['api_platform.serializer.default_context'], $m, NULL);

        $o = new \ApiPlatform\JsonLd\Serializer\ErrorNormalizer($n, $container->parameters['api_platform.serializer.default_context']);
        $p = ($container->privates['api_platform.router'] ?? self::getApiPlatform_RouterService($container));
        $q = new \ApiPlatform\Serializer\ItemNormalizer($c, $d, $e, $k, $g, $j, $l, NULL, $b, $m, [], NULL);
        $r = ($container->services['translator'] ?? self::getTranslatorService($container));
        $s = ($container->privates['serializer.name_converter.metadata_aware'] ?? self::getSerializer_NameConverter_MetadataAwareService($container));
        $t = new \Symfony\Component\Serializer\Mapping\ClassDiscriminatorFromClassMetadata($l);
        $u = new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer($l, $s, $g, $a, $t, NULL, $container->parameters['api_platform.serializer.default_context'], $a);
        $v = new \Symfony\Component\Serializer\Encoder\YamlEncoder(NULL, NULL, $container->parameters['api_platform.serializer.default_context']);

        return $container->privates['serializer'] = new \Symfony\Component\Serializer\Serializer([new \Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer($g), $i, $i, new \ApiPlatform\Serializer\ConstraintViolationListNormalizer([], $j), new \ApiPlatform\Hydra\Serializer\ConstraintViolationListNormalizer([], $j, $container->parameters['api_platform.serializer.default_context']), $i, new \ApiPlatform\Symfony\Validator\Serializer\ValidationExceptionNormalizer($o, $j), new \ApiPlatform\Hydra\Serializer\DocumentationNormalizer($b, $c, $d, $k, $p, $j, $container->parameters['api_platform.serializer.default_context'], true), new \ApiPlatform\Hydra\Serializer\EntrypointNormalizer($b, $e, $p), new \ApiPlatform\Symfony\Validator\Serializer\ValidationExceptionNormalizer($q, $j), new \Symfony\Component\Messenger\Transport\Serialization\Normalizer\FlattenExceptionNormalizer(), $o, new \Symfony\Component\Serializer\Normalizer\ProblemNormalizer(false, $container->parameters['api_platform.serializer.default_context'], $r), new \Symfony\Component\Serializer\Normalizer\UidNormalizer($container->parameters['api_platform.serializer.default_context']), $n, $q, new \Symfony\Component\Serializer\Normalizer\DateTimeNormalizer($container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\ConstraintViolationListNormalizer($container->parameters['api_platform.serializer.default_context'], $s), new \Symfony\Component\Serializer\Normalizer\MimeMessageNormalizer(new \Symfony\Component\Serializer\Normalizer\PropertyNormalizer($l, $s, $a, $t, NULL, [])), new \Symfony\Component\Serializer\Normalizer\DateTimeZoneNormalizer(), new \Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer($container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\FormErrorNormalizer(), new \Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer(), new \Symfony\Component\Serializer\Normalizer\NumberNormalizer(), new \Symfony\Component\Serializer\Normalizer\DataUriNormalizer(($container->privates['mime_types'] ?? self::getMimeTypesService($container))), new \Symfony\Component\Serializer\Normalizer\TranslatableNormalizer($r, $container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer(NULL, NULL, $container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Hydra\Serializer\CollectionFiltersNormalizer(new \ApiPlatform\Hydra\Serializer\PartialCollectionViewNormalizer(new \ApiPlatform\Hydra\Serializer\CollectionNormalizer($f, $k, $e, $container->parameters['api_platform.serializer.default_context']), 'page', 'pagination', $b, $g, 1, $container->parameters['api_platform.serializer.default_context']), $b, $k, ($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])), $container->parameters['api_platform.serializer.default_context']), new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \ApiPlatform\JsonLd\Serializer\ObjectNormalizer($u, $e, $f), $u], [new \Symfony\Component\Serializer\Encoder\XmlEncoder($container->parameters['api_platform.serializer.default_context']), $h, $v, new \Symfony\Component\Serializer\Encoder\CsvEncoder($container->parameters['api_platform.serializer.default_context']), new \ApiPlatform\Serializer\JsonEncoder('jsonopenapi', NULL), new \ApiPlatform\Serializer\YamlEncoder('yamlopenapi', $v), new \ApiPlatform\Serializer\JsonEncoder('jsonld', NULL), new \ApiPlatform\Serializer\JsonEncoder('jsonproblem')], $container->parameters['api_platform.serializer.default_context']);
    }

    /*
     * Gets the private 'serializer.name_converter.metadata_aware' shared service.
     *
     * @return \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter
     */
    protected static function getSerializer_NameConverter_MetadataAwareService($container)
    {
        return $container->privates['serializer.name_converter.metadata_aware'] = new \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter(($container->privates['api_platform.serializer.mapping.cache_class_metadata_factory'] ?? self::getApiPlatform_Serializer_Mapping_CacheClassMetadataFactoryService($container)));
    }

    /*
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected static function getSessionListenerService($container)
    {
        return $container->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'session_factory' => ['privates', 'session.factory', 'getSession_FactoryService', true],
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'session_factory' => '?',
            'logger' => '?',
            'request_stack' => '?',
        ]), false, $container->parameters['session.storage.options']);
    }

    /*
     * Gets the private 'uri_signer' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\UriSigner
     */
    protected static function getUriSignerService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->privates['uri_signer'] = $container->createProxy('UriSignerGhost95dd497', static fn () => \UriSignerGhost95dd497::createLazyGhost(static fn ($proxy) => self::getUriSignerService($container, $proxy)));
        }

        return ($lazyLoad->__construct($container->getParameter('kernel.secret'), '_hash', '_expiration', ($container->privates['clock'] ??= new \Symfony\Component\Clock\Clock())) && false ?: $lazyLoad);
    }

    /*
     * Gets the private 'validator' shared service.
     *
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    protected static function getValidatorService($container)
    {
        $a = ($container->privates['validator.builder'] ?? self::getValidator_BuilderService($container));

        if (isset($container->privates['validator'])) {
            return $container->privates['validator'];
        }

        return $container->privates['validator'] = $a->getValidator();
    }

    /*
     * Gets the private 'validator.builder' shared service.
     *
     * @return \Symfony\Component\Validator\ValidatorBuilder
     */
    protected static function getValidator_BuilderService($container)
    {
        $container->privates['validator.builder'] = $instance = \Symfony\Component\Validator\Validation::createValidatorBuilder();

        $a = ($container->privates['property_info.cache'] ?? self::getPropertyInfo_CacheService($container));

        $instance->setConstraintValidatorFactory(new \Symfony\Component\Validator\ContainerConstraintValidatorFactory(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'validator.expression' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => ['privates', 'validator.expression', 'getValidator_ExpressionService', true],
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => ['privates', 'validator.email', 'getValidator_EmailService', true],
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => ['privates', 'validator.not_compromised_password', 'getValidator_NotCompromisedPasswordService', true],
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => ['privates', 'validator.when', 'getValidator_WhenService', true],
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => ['privates', 'validator.no_suspicious_characters', 'getValidator_NoSuspiciousCharactersService', true],
            'doctrine.orm.validator.unique' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => ['privates', 'doctrine.orm.validator.unique', 'getDoctrine_Orm_Validator_UniqueService', true],
            'Symfony\\Bridge\\Twig\\Validator\\Constraints\\TwigValidator' => ['privates', 'twig.validator', 'getTwig_ValidatorService', true],
            'security.validator.user_password' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => ['privates', 'security.validator.user_password', 'getSecurity_Validator_UserPasswordService', true],
        ], [
            'validator.expression' => '?',
            'Symfony\\Component\\Validator\\Constraints\\ExpressionValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\EmailValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NotCompromisedPasswordValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\WhenValidator' => '?',
            'Symfony\\Component\\Validator\\Constraints\\NoSuspiciousCharactersValidator' => '?',
            'doctrine.orm.validator.unique' => '?',
            'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator' => '?',
            'Symfony\\Bridge\\Twig\\Validator\\Constraints\\TwigValidator' => '?',
            'security.validator.user_password' => '?',
            'Symfony\\Component\\Security\\Core\\Validator\\Constraints\\UserPasswordValidator' => '?',
        ])));
        $instance->setGroupProviderLocator(($container->privates['api_platform.filter_locator'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], [])));
        if ($container->has('translator')) {
            $instance->setTranslator(($container->services['translator'] ?? self::getTranslatorService($container)));
        }
        $instance->setTranslationDomain('validators');
        $instance->enableAttributeMapping();
        $instance->addMethodMapping('loadValidatorMetadata');
        $instance->setMappingCache(\Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($container->targetDir.''.'/validation.php'), ($container->privates['cache.validator'] ?? self::getCache_ValidatorService($container))));
        $instance->addObjectInitializers([new \Symfony\Bridge\Doctrine\Validator\DoctrineInitializer(($container->services['doctrine'] ?? self::getDoctrineService($container)))]);
        $instance->addAttributeMappings(['Symfony\\Component\\Form\\Form' => ['Symfony\\Component\\Form\\Form']]);
        $instance->addLoader(new \Symfony\Component\Validator\Mapping\Loader\PropertyInfoLoader($a, $a, $a, NULL));
        $instance->addLoader(new \Symfony\Bridge\Doctrine\Validator\DoctrineLoader(($container->services['doctrine.orm.default_entity_manager'] ?? self::getDoctrine_Orm_DefaultEntityManagerService($container)), NULL));

        return $instance;
    }

    /*
     * Gets the private 'web_link.add_link_header_listener' shared service.
     *
     * @return \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener
     */
    protected static function getWebLink_AddLinkHeaderListenerService($container)
    {
        return $container->privates['web_link.add_link_header_listener'] = new \Symfony\Component\WebLink\EventListener\AddLinkHeaderListener(($container->privates['web_link.http_header_serializer'] ??= new \Symfony\Component\WebLink\HttpHeaderSerializer()));
    }

    /*
     * Gets the private 'web_link.http_header_serializer' shared service.
     *
     * @return \Symfony\Component\WebLink\HttpHeaderSerializer
     */
    protected static function getWebLink_HttpHeaderSerializerService($container)
    {
        return $container->privates['web_link.http_header_serializer'] = new \Symfony\Component\WebLink\HttpHeaderSerializer();
    }

    public function getParameter(string $name): array|bool|string|int|float|\UnitEnum|null
    {
        if (isset(self::DEPRECATED_PARAMETERS[$name])) {
            trigger_deprecation(...self::DEPRECATED_PARAMETERS[$name]);
        }

        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new ParameterNotFoundException($name, extraMessage: self::NONEMPTY_PARAMETERS[$name] ?? null);
        }

        if (isset($this->loadedDynamicParameters[$name])) {
            $value = $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        } else {
            $value = $this->parameters[$name];
        }

        if (isset(self::NONEMPTY_PARAMETERS[$name]) && (null === $value || '' === $value || [] === $value)) {
            throw new \Symfony\Component\DependencyInjection\Exception\EmptyParameterValueException(self::NONEMPTY_PARAMETERS[$name]);
        }

        return $value;
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (!isset($this->parameterBag)) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters, self::DEPRECATED_PARAMETERS, self::NONEMPTY_PARAMETERS);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.runtime_mode' => false,
        'kernel.runtime_mode.web' => false,
        'kernel.runtime_mode.cli' => false,
        'kernel.runtime_mode.worker' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'app.url' => false,
        'frontend.url' => false,
        'kernel.secret' => false,
        'kernel.trust_x_sendfile_type_header' => false,
        'kernel.trusted_hosts' => false,
        'kernel.trusted_proxies' => false,
        'kernel.trusted_headers' => false,
        'router.cache_dir' => false,
        'serializer.mapping.cache.file' => false,
        'validator.mapping.cache.file' => false,
        'doctrine.orm.proxy_dir' => false,
        'nelmio_cors.defaults' => false,
        'lexik_jwt_authentication.pass_phrase' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        $container = $this;
        $value = match ($name) {
            'kernel.runtime_environment' => $container->getEnv('default:kernel.environment:APP_RUNTIME_ENV'),
            'kernel.runtime_mode' => $container->getEnv('query_string:default:container.runtime_mode:APP_RUNTIME_MODE'),
            'kernel.runtime_mode.web' => $container->getEnv('bool:default::key:web:default:kernel.runtime_mode:'),
            'kernel.runtime_mode.cli' => $container->getEnv('not:default:kernel.runtime_mode.web:'),
            'kernel.runtime_mode.worker' => $container->getEnv('bool:default::key:worker:default:kernel.runtime_mode:'),
            'kernel.build_dir' => $container->targetDir.'',
            'kernel.cache_dir' => $container->targetDir.'',
            'app.url' => $container->getEnv('APP_URL'),
            'frontend.url' => $container->getEnv('FRONTEND_URL'),
            'kernel.secret' => $container->getEnv('APP_SECRET'),
            'kernel.trust_x_sendfile_type_header' => $container->getEnv('bool:default::SYMFONY_TRUST_X_SENDFILE_TYPE_HEADER'),
            'kernel.trusted_hosts' => $container->getEnv('default::SYMFONY_TRUSTED_HOSTS'),
            'kernel.trusted_proxies' => $container->getEnv('default::SYMFONY_TRUSTED_PROXIES'),
            'kernel.trusted_headers' => $container->getEnv('default::SYMFONY_TRUSTED_HEADERS'),
            'router.cache_dir' => $container->targetDir.'',
            'serializer.mapping.cache.file' => ($container->targetDir.''.'/serialization.php'),
            'validator.mapping.cache.file' => ($container->targetDir.''.'/validation.php'),
            'doctrine.orm.proxy_dir' => ($container->targetDir.''.'/doctrine/orm/Proxies'),
            'nelmio_cors.defaults' => [
                'allow_origin' => [
                    0 => $container->getEnv('CORS_ALLOW_ORIGIN'),
                ],
                'allow_credentials' => false,
                'allow_headers' => [
                    0 => 'content-type',
                    1 => 'authorization',
                ],
                'allow_private_network' => false,
                'expose_headers' => [
                    0 => 'Link',
                ],
                'allow_methods' => [
                    0 => 'GET',
                    1 => 'OPTIONS',
                    2 => 'POST',
                    3 => 'PUT',
                    4 => 'PATCH',
                    5 => 'DELETE',
                ],
                'max_age' => 3600,
                'hosts' => [

                ],
                'origin_regex' => true,
                'skip_same_as_origin' => true,
                'forced_allow_origin_value' => NULL,
            ],
            'lexik_jwt_authentication.pass_phrase' => $container->getEnv('JWT_PASSPHRASE'),
            default => throw new ParameterNotFoundException($name),
        };
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'prod',
            'kernel.debug' => false,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/log'),
            'kernel.bundles' => [
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'DoctrineMigrationsBundle' => 'Doctrine\\Bundle\\MigrationsBundle\\DoctrineMigrationsBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'StimulusBundle' => 'Symfony\\UX\\StimulusBundle\\StimulusBundle',
                'TurboBundle' => 'Symfony\\UX\\Turbo\\TurboBundle',
                'TwigExtraBundle' => 'Twig\\Extra\\TwigExtraBundle\\TwigExtraBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'NelmioCorsBundle' => 'Nelmio\\CorsBundle\\NelmioCorsBundle',
                'ApiPlatformBundle' => 'ApiPlatform\\Symfony\\Bundle\\ApiPlatformBundle',
                'LexikJWTAuthenticationBundle' => 'Lexik\\Bundle\\JWTAuthenticationBundle\\LexikJWTAuthenticationBundle',
            ],
            'kernel.bundles_metadata' => [
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'DoctrineMigrationsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-migrations-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\MigrationsBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'StimulusBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/stimulus-bundle'),
                    'namespace' => 'Symfony\\UX\\StimulusBundle',
                ],
                'TurboBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/ux-turbo'),
                    'namespace' => 'Symfony\\UX\\Turbo',
                ],
                'TwigExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle'),
                    'namespace' => 'Twig\\Extra\\TwigExtraBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle/src'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'NelmioCorsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle'),
                    'namespace' => 'Nelmio\\CorsBundle',
                ],
                'ApiPlatformBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/api-platform/symfony/Bundle'),
                    'namespace' => 'ApiPlatform\\Symfony\\Bundle',
                ],
                'LexikJWTAuthenticationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/lexik/jwt-authentication-bundle'),
                    'namespace' => 'Lexik\\Bundle\\JWTAuthenticationBundle',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'App_KernelProdContainer',
            'kernel.share_dir' => (\dirname(__DIR__, 3).'/share/prod'),
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\Form\\Event\\PreSubmitEvent' => 'form.pre_submit',
                'Symfony\\Component\\Form\\Event\\SubmitEvent' => 'form.submit',
                'Symfony\\Component\\Form\\Event\\PostSubmitEvent' => 'form.post_submit',
                'Symfony\\Component\\Form\\Event\\PreSetDataEvent' => 'form.pre_set_data',
                'Symfony\\Component\\Form\\Event\\PostSetDataEvent' => 'form.post_set_data',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => false,
            'kernel.allowed_http_method_override' => NULL,
            'kernel.default_locale' => 'en',
            'kernel.enabled_locales' => [

            ],
            'kernel.error_controller' => 'error_controller',
            'debug.file_link_format' => NULL,
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 4).'/translations'),
            'debug.error_handler.throw_at' => 0,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'kernel::loadRoutes',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
            ],
            'session.save_path' => NULL,
            'session.metadata.update_threshold' => 0,
            'form.type_extension.csrf.enabled' => true,
            'form.type_extension.csrf.field_name' => '_token',
            'form.type_extension.csrf.field_attr' => [
                'data-controller' => 'csrf-protection',
            ],
            'validator.translation_domain' => 'validators',
            'data_collector.templates' => [

            ],
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [
                'uuid' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\UuidType',
                ],
                'ulid' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\UlidType',
                ],
                'date_point' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\DatePointType',
                ],
                'day_point' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\DayPointType',
                ],
                'time_point' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\TimePointType',
                ],
            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.typed_field_mapper.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultTypedFieldMapper',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => false,
            'doctrine.orm.enable_lazy_ghost_objects' => true,
            'doctrine.orm.enable_native_lazy_objects' => false,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'doctrine.migrations.preferred_em' => NULL,
            'doctrine.migrations.preferred_connection' => NULL,
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 4).'/templates'),
            'security.role_hierarchy.roles' => [
                'ROLE_ADMIN' => [
                    0 => 'ROLE_STAFF',
                    1 => 'ROLE_USER',
                ],
                'ROLE_STAFF' => [
                    0 => 'ROLE_USER',
                ],
            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'dev',
                1 => 'login',
                2 => 'api',
                3 => 'main',
            ],
            'security.logout_uris' => [

            ],
            'monolog.use_microseconds' => true,
            'monolog.handlers_to_channels' => [
                'monolog.handler.deprecation' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'deprecation',
                    ],
                ],
                'monolog.handler.console' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'event',
                        1 => 'doctrine',
                    ],
                ],
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'deprecation',
                    ],
                ],
            ],
            'nelmio_cors.map' => [
                '^/' => [

                ],
            ],
            'nelmio_cors.cors_listener.class' => 'Nelmio\\CorsBundle\\EventListener\\CorsListener',
            'nelmio_cors.options_resolver.class' => 'Nelmio\\CorsBundle\\Options\\Resolver',
            'nelmio_cors.options_provider.config.class' => 'Nelmio\\CorsBundle\\Options\\ConfigProvider',
            'api_platform.use_symfony_listeners' => false,
            'api_platform.serializer.default_context' => [
                'hydra_prefix' => false,
            ],
            'api_platform.enable_entrypoint' => true,
            'api_platform.enable_docs' => true,
            'api_platform.title' => 'Hello API Platform',
            'api_platform.description' => '',
            'api_platform.version' => '1.0.0',
            'api_platform.show_webby' => true,
            'api_platform.url_generation_strategy' => 1,
            'api_platform.exception_to_status' => [
                'Symfony\\Component\\Serializer\\Exception\\ExceptionInterface' => 400,
                'ApiPlatform\\Metadata\\Exception\\InvalidArgumentException' => 400,
                'Doctrine\\ORM\\OptimisticLockException' => 409,
            ],
            'api_platform.formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'json' => [
                    0 => 'application/json',
                ],
            ],
            'api_platform.patch_formats' => [
                'json' => [
                    0 => 'application/merge-patch+json',
                ],
            ],
            'api_platform.error_formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'jsonproblem' => [
                    0 => 'application/problem+json',
                ],
                'json' => [
                    0 => 'application/problem+json',
                    1 => 'application/json',
                ],
            ],
            'api_platform.docs_formats' => [
                'jsonld' => [
                    0 => 'application/ld+json',
                ],
                'jsonopenapi' => [
                    0 => 'application/vnd.openapi+json',
                ],
                'html' => [
                    0 => 'text/html',
                ],
                'yamlopenapi' => [
                    0 => 'application/vnd.openapi+yaml',
                ],
            ],
            'api_platform.jsonschema_formats' => [

            ],
            'api_platform.eager_loading.enabled' => true,
            'api_platform.eager_loading.max_joins' => 30,
            'api_platform.eager_loading.fetch_partial' => false,
            'api_platform.eager_loading.force_eager' => true,
            'api_platform.collection.exists_parameter_name' => 'exists',
            'api_platform.collection.order' => 'ASC',
            'api_platform.collection.order_parameter_name' => 'order',
            'api_platform.collection.order_nulls_comparison' => NULL,
            'api_platform.collection.pagination.enabled' => true,
            'api_platform.collection.pagination.partial' => false,
            'api_platform.collection.pagination.client_enabled' => false,
            'api_platform.collection.pagination.client_items_per_page' => false,
            'api_platform.collection.pagination.client_partial' => false,
            'api_platform.collection.pagination.items_per_page' => 30,
            'api_platform.collection.pagination.maximum_items_per_page' => 30,
            'api_platform.collection.pagination.page_parameter_name' => 'page',
            'api_platform.collection.pagination.enabled_parameter_name' => 'pagination',
            'api_platform.collection.pagination.items_per_page_parameter_name' => 'itemsPerPage',
            'api_platform.collection.pagination.partial_parameter_name' => 'partial',
            'api_platform.collection.pagination' => [
                'enabled' => true,
                'page_parameter_name' => 'page',
                'enabled_parameter_name' => 'pagination',
                'items_per_page_parameter_name' => 'itemsPerPage',
                'partial_parameter_name' => 'partial',
            ],
            'api_platform.handle_symfony_errors' => false,
            'api_platform.http_cache.etag' => true,
            'api_platform.http_cache.max_age' => NULL,
            'api_platform.http_cache.shared_max_age' => NULL,
            'api_platform.http_cache.vary' => [
                0 => 'Content-Type',
                1 => 'Authorization',
                2 => 'Origin',
            ],
            'api_platform.http_cache.public' => NULL,
            'api_platform.http_cache.invalidation.max_header_length' => 7500,
            'api_platform.http_cache.invalidation.xkey.glue' => ' ',
            'api_platform.asset_package' => NULL,
            'api_platform.defaults' => [
                'extra_properties' => [

                ],
                'stateless' => true,
                'cache_headers' => [
                    'vary' => [
                        0 => 'Content-Type',
                        1 => 'Authorization',
                        2 => 'Origin',
                    ],
                ],
            ],
            'api_platform.resource_class_directories' => [
                0 => (\dirname(__DIR__, 4).'/src/ApiResource'),
                1 => (\dirname(__DIR__, 4).'/src/Entity'),
            ],
            'api_platform.class_name_resources' => [
                0 => 'ApiPlatform\\State\\ApiResource\\Error',
                1 => 'ApiPlatform\\Validator\\Exception\\ValidationException',
            ],
            'api_platform.oauth.enabled' => false,
            'api_platform.oauth.clientId' => '',
            'api_platform.oauth.clientSecret' => '',
            'api_platform.oauth.type' => 'oauth2',
            'api_platform.oauth.flow' => 'application',
            'api_platform.oauth.tokenUrl' => '',
            'api_platform.oauth.authorizationUrl' => '',
            'api_platform.oauth.refreshUrl' => '',
            'api_platform.oauth.scopes' => [

            ],
            'api_platform.oauth.pkce' => false,
            'api_platform.openapi.termsOfService' => NULL,
            'api_platform.openapi.contact.name' => NULL,
            'api_platform.openapi.contact.url' => NULL,
            'api_platform.openapi.contact.email' => NULL,
            'api_platform.openapi.license.name' => NULL,
            'api_platform.openapi.license.url' => NULL,
            'api_platform.openapi.license.identifier' => NULL,
            'api_platform.openapi.overrideResponses' => true,
            'api_platform.openapi.tags' => [

            ],
            'api_platform.openapi.errorResourceClass' => NULL,
            'api_platform.openapi.validationErrorResourceClass' => NULL,
            'api_platform.swagger.versions' => [
                0 => 3,
            ],
            'api_platform.enable_swagger_ui' => true,
            'api_platform.enable_re_doc' => true,
            'api_platform.swagger.api_keys' => [

            ],
            'api_platform.swagger.persist_authorization' => false,
            'api_platform.swagger.http_auth' => [

            ],
            'api_platform.swagger_ui.extra_configuration' => [

            ],
            'api_platform.graphql.enabled' => false,
            'api_platform.graphql.max_query_depth' => 20,
            'api_platform.graphql.max_query_complexity' => 500,
            'api_platform.graphql.introspection.enabled' => false,
            'api_platform.graphql.graphiql.enabled' => false,
            'api_platform.graphql.collection.pagination' => [
                'enabled' => true,
            ],
            'api_platform.validator.serialize_payload_fields' => [

            ],
            'api_platform.elasticsearch.enabled' => false,
            'lexik_jwt_authentication.token_ttl' => 3600,
            'lexik_jwt_authentication.clock_skew' => 0,
            'lexik_jwt_authentication.allow_no_expiration' => false,
            'lexik_jwt_authentication.user_id_claim' => 'username',
            'lexik_jwt_authentication.encoder.signature_algorithm' => 'RS256',
            'console.command.ids' => [

            ],
        ];
    }
}
