<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProcessorInterface;
use Symfony\Bundle\SecurityBundle\Security;
use App\Entity\Subscription;

final class SubscriptionProcessor implements ProcessorInterface
{
    public function __construct(
        private Security $security,
        private ProcessorInterface $persistProcessor
    ) {}

    public function process(
        mixed $data,
        Operation $operation,
        array $uriVariables = [],
        array $context = []
    ): mixed {
        if ($data instanceof Subscription) {
            $user = $this->security->getUser();

            if (!$user) {
                throw new \Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException(
                    'Bearer',
                    'User must be authenticated'
                );
            }

            $data->setUser($user);
        }

        return $this->persistProcessor->process(
            $data,
            $operation,
            $uriVariables,
            $context
        );
    }
}
