<?php
// src/EventListener/JWTCreatedListener.php

namespace App\EventListener;

use Lexik\Bundle\JWTAuthenticationBundle\Event\JWTCreatedEvent;
use App\Entity\User; // Adjust if your User entity namespace is different

class JWTCreatedListener
{
    /**
     * @param JWTCreatedEvent $event
     */
    public function onJWTCreated(JWTCreatedEvent $event): void
    {
        /** @var User $user */
        $user = $event->getUser();

        // Add custom claims to the payload (v3 method names)
        $payload = $event->getData(); // ← Changed from getPayload()
        $payload['id'] = $user->getId();
        $payload['email'] = $user->getEmail();
        $payload['firstName'] = $user->getFirstName();
        $payload['lastName'] = $user->getLastName();
        $payload['phoneNumber'] = $user->getPhoneNumber();
        $payload['roles'] = $user->getRoles(); // Full roles array
        $payload['isVerified'] = $user->isVerified();

        $event->setData($payload); // ← Changed from setPayload()
    }
}
