<?php

namespace App\EventListener;

use App\Entity\User;
use Lexik\Bundle\JWTAuthenticationBundle\Event\AuthenticationSuccessEvent;

class EmailVerificationListener
{
    public function onAuthenticationSuccess(AuthenticationSuccessEvent $event): void
    {
        $user = $event->getUser();

        if (!$user instanceof User) {
            return;
        }

        // Check if email is verified
        if (!$user->isVerified()) {
            // Override the response to prevent token from being issued
            $event->setData([
                'code' => 403,
                'message' => 'Please verify your email address before logging in. Check your inbox for the verification link.',
            ]);

            return;
        }

        // Add user info to JWT response for verified users
        $data = $event->getData();

        // Ensure we have the token
        if (!isset($data['token'])) {
            return;
        }

        // Add complete user information
        $data['user'] = [
            'id' => $user->getId(),
            'email' => $user->getEmail(),
            'firstName' => $user->getFirstName(),
            'lastName' => $user->getLastName(),
            'phoneNumber' => $user->getPhoneNumber(),
            'roles' => $user->getRoles(),
            'isVerified' => $user->isVerified(),
        ];

        $event->setData($data);
    }
}
