<?php

namespace App\Controller;

use App\Entity\User;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Attribute\Route;

class VerifyEmailController
{
    public function __construct(
        private EntityManagerInterface $em
    ) {}

    #[Route('/auth/verify-email', name: 'auth_verify_email', methods: ['POST'])]
    public function __invoke(Request $request): JsonResponse
    {
        $data = json_decode($request->getContent(), true);

        if (empty($data['token'])) {
            return new JsonResponse(['error' => 'Token is required'], 400);
        }

        $user = $this->em
            ->getRepository(User::class)
            ->findOneBy(['verificationToken' => $data['token']]);

        if (!$user) {
            return new JsonResponse(['error' => 'Invalid verification token'], 400);
        }

        if ($user->isVerified()) {
            return new JsonResponse(['message' => 'Email already verified'], 200);
        }

        $user->setIsVerified(true);
        $user->setVerificationToken(null);

        $this->em->flush();

        return new JsonResponse(['message' => 'Email verified successfully'], 200);
    }
}
