<?php

namespace App\Controller;

use App\Entity\Exam;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

class ExamSubjectsController extends AbstractController
{
    #[Route('/api/exams/{id}/subjects-with-count', name: 'api_exam_subjects_with_count', methods: ['GET'])]
    #[IsGranted('IS_AUTHENTICATED_ANONYMOUSLY')]
    public function __invoke(Exam $exam, EntityManagerInterface $em): JsonResponse
    {
        $qb = $em->createQueryBuilder();

        $results = $qb->select('s.id, s.name, COUNT(q.id) as questionCount')
            ->from('App\Entity\Subject', 's')
            ->leftJoin('App\Entity\Question', 'q', 'WITH', 'q.subject = s.id AND q.exam = :exam')
            ->where('s.exam = :exam')
            ->setParameter('exam', $exam)
            ->groupBy('s.id')
            ->orderBy('s.name', 'ASC')
            ->getQuery()
            ->getArrayResult();

        return $this->json([
            'exam' => ['id' => $exam->getId(), 'name' => $exam->getName(), 'year' => $exam->getYear()],
            'subjects' => array_map(function ($row) {
                return [
                    'id' => (int)$row['id'],
                    'name' => $row['name'],
                    'questionCount' => (int)$row['questionCount'],
                ];
            }, $results)
        ]);
    }
}


