<?php

namespace App\Command;

use App\Entity\User;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

#[AsCommand(
    name: 'app:create-user',
    description: 'Create an admin user'
)]
class CreateUserCommand extends Command
{
    public function __construct(
        private EntityManagerInterface $em,
        private UserPasswordHasherInterface $passwordHasher
    ) {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);

        /** ✅ Prevent duplicate admin creation */
        $existingUser = $this->em
            ->getRepository(User::class)
            ->findOneBy(['email' => 'admin@example.com']);

        if ($existingUser) {
            $io->warning('Admin user already exists.');
            return Command::SUCCESS;
        }

        $user = new User();
        $user->setEmail('admin@example.com');
        $user->setFirstName('Admin');
        $user->setLastName('User');
        $user->setRoles(['ROLE_ADMIN']);
        $user->setIsVerified(true);

        /** ✅ Always hash password */
        $user->setPassword(
            $this->passwordHasher->hashPassword($user, 'admin123')
        );

        $this->em->persist($user);
        $this->em->flush();

        $io->success('Admin user created successfully ✅');

        return Command::SUCCESS;
    }
}


// php bin/console app:create-user
